/****************************************************************************
* Copyright (c) 2017-2018 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
****************************************************************************/

#ifndef HMI_HMI_MASTER_PROXYHANDLER_APPEXT_H
#define HMI_HMI_MASTER_PROXYHANDLER_APPEXT_H

#include "ProjectBaseTypes.h" // enApplicationId
#include "HMIAppCtrl/Proxy/ProxyHandler.h"

namespace hmi {
namespace apphmi_master {

/// this is the specialized proxy handler implementation
/// mainly to extend the original ProxyHandler by status line control functionality
class ProxyHandler_AppExt : public hmibase::services::hmiappctrl::ProxyHandler
{
   public:
      ProxyHandler_AppExt() {};
      virtual ~ProxyHandler_AppExt() {};

      virtual void onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal >& statusEvalSignal);
      void requestStatusLineCmd(std::string ApplicationName, int status);

   private:
      std::map<std::string, bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData*> mStatusLineTable;
};


}
}


#endif // HMI_HMI_MASTER_PROXYHANDLER_APPEXT_H
