/**************************************************************************************
 * @file         : IHmiAppCtrlAppInfoInterface.h
 * @author       : AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : IHmiAppCtrlAppInfoInterface is to provide interface impl
 *                 between HmiAppCtrl and App Info users
 *                 (Dependency Breaker Strategy)
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef IHMIAPPCTRL_APPINFO_INTERFACE_H
#define IHMIAPPCTRL_APPINFO_INTERFACE_H


#include "asf/core/Types.h"


namespace hmi {
namespace apphmi_master {


class IHmiAppCtrlAppInfoInterface
{
   public:
      IHmiAppCtrlAppInfoInterface() {}
      virtual ~IHmiAppCtrlAppInfoInterface() {}
      virtual ::std::string getApplicationNameForPid(const int pid) const = 0;
      virtual ::std::string getApplicationNameForAppId(const unsigned int appId) const = 0;
      virtual bool isAppPid(const int pid) = 0;
      virtual int getPidOfApp(const int appId) const = 0;
      virtual unsigned int getApplicationId(const ::std::string& appName) const = 0;
};


} //namespace apphmi_master
} //namespace hmi


#endif /* IHMIAPPCTRL_APPINFO_INTERFACE_H */
