/**************************************************************************************
* @file         : <HeatCtrlClientHandler.cpp>
* @author       : <ECG> <INF4CV> Alfa Kumar Mohapatra
* @addtogroup   :
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HEATCTRLCLIENTHANDLER_H
#define HEATCTRLCLIENTHANDLER_H


#include "heatctrl_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/StartupSync/StartupSync.h"

namespace App {
namespace Core {

class HeatCtrlClientHandler : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public heatctrl_main_fi::EmergencyFunctionsCallbackIF
{
   public:
	  HeatCtrlClientHandler();
      virtual ~HeatCtrlClientHandler();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onEmergencyFunctionsError(const ::boost::shared_ptr< ::heatctrl_main_fi::Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< heatctrl_main_fi::EmergencyFunctionsError >& error);

      void onEmergencyFunctionsStatus(const ::boost::shared_ptr< ::heatctrl_main_fi::Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< heatctrl_main_fi::EmergencyFunctionsStatus >& status);

   private:

	  HeatCtrlClientHandler(const HeatCtrlClientHandler& );
	  HeatCtrlClientHandler& operator = (const HeatCtrlClientHandler& );
	  act_t _getHeatCtrlHandlerPropertiesAct;

      ::boost::shared_ptr< ::heatctrl_main_fi::Heatctrl_main_fiProxy > m_HeatCtrlFiProxy;
};


}
}


#endif
