/**************************************************************************************
* @file         : <HeatCtrlClientHandler.cpp>
* @author       : <ECH> <INF4CV> Alfa Mohapatra
* @addtogroup   : <AppHmi_Master>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "HeatCtrlClientHandler.h"
#include "AppHmi_MasterMessages.h"
//#include "CanderaWidget/String/String.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MASTER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Master_"
#define ETG_I_FILE_PREFIX                 App::Core::HeatCtrlClientHandler::
#include "trcGenProj/Header/HeatCtrlClientHandler.cpp.trc.h"
#endif


using namespace ::heatctrl_main_fi;
using namespace ::heatctrl_main_fi_types;

namespace App {
namespace Core {


HeatCtrlClientHandler::HeatCtrlClientHandler(): m_HeatCtrlFiProxy(::heatctrl_main_fi::Heatctrl_main_fiProxy::createProxy("heatCtrlMainFiPort", *this))
                                              , _getHeatCtrlHandlerPropertiesAct(0)
{
   ETG_TRACE_USR4(("HeatCtrlClientHandler Constructor is called"));
   if (m_HeatCtrlFiProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, m_HeatCtrlFiProxy->getPortName());
   }
}


HeatCtrlClientHandler::~HeatCtrlClientHandler()
{}


void HeatCtrlClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (m_HeatCtrlFiProxy.get() && (proxy == m_HeatCtrlFiProxy))
    {
	   _getHeatCtrlHandlerPropertiesAct = m_HeatCtrlFiProxy->sendEmergencyFunctionsUpReg(*this);
    }
}


void HeatCtrlClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (m_HeatCtrlFiProxy.get() && (proxy == m_HeatCtrlFiProxy))
    {
       m_HeatCtrlFiProxy->sendEmergencyFunctionsRelUpRegAll();
       _getHeatCtrlHandlerPropertiesAct =0;
    }
}


void HeatCtrlClientHandler::onEmergencyFunctionsError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< EmergencyFunctionsError >& error)
{
   ETG_TRACE_ERR(("HeatCtrlClientHandler:: onEmergencyFunctionsError error field %d", error->getField()));
   ETG_TRACE_ERR(("HeatCtrlClientHandler:: onEmergencyFunctionsError getSystemErrorCode %d", error->getSystemErrorCode()));
}


void HeatCtrlClientHandler::onEmergencyFunctionsStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< EmergencyFunctionsStatus >& status)
{
   bool activationStatus = false;
   if (m_HeatCtrlFiProxy.get() && (_getHeatCtrlHandlerPropertiesAct == status->getAct()) && (proxy == m_HeatCtrlFiProxy))
   {
      const ::heatctrl_main_fi_types::T_EmergencyFunctionList& list = status->getList();
	  for(::heatctrl_main_fi_types::T_EmergencyFunctionList::const_iterator itr = list.begin(); (itr != list.end()) && !activationStatus; ++itr)
	  {
	      switch ((*itr).getID())
	      {
	         case T_e8_EmergncyFunctionID__FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNHIGHTEMP:
	      	 case T_e8_EmergncyFunctionID__FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNLOWTEMP:
	      	 {
	      	    if((*itr).getState() == T_e8_EmergncyFunctionState__FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE)
	      	   	{
	      	       activationStatus =true;
	      	   	}
	      	  }
	      	 break;

	      	 default:
	      	   break;
	       }
	    }

	    EmergencyShutDownReqMsg* EmergencyShutDownMsg = COURIER_MESSAGE_NEW(EmergencyShutDownReqMsg)(activationStatus);
	    if (EmergencyShutDownMsg != 0)
	    {
	       EmergencyShutDownMsg->Post();
	    }
   }


} 


}// end of namespace Core
}//end of namespace App
