/**
 * @file         : ContextPriorityHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ContextPriorityHandler is to handle the context priority information.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CONTEXT_PRIORITY_HANDLER_H
#define CONTEXT_PRIORITY_HANDLER_H


#include "ContextPriorityHandlerInterface.h"
#include <map>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * ContextPriorityHandler is used to
 *  - Handle the context priority information
 */
class ContextPriorityHandler : public IContextPriorityHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      ContextPriorityHandler();
      virtual ~ContextPriorityHandler();
      uint8 getContextPriority(const uint32 contextId) const;

   private:
      /**
       *  Member Typedefs Declaration
       */
      typedef ::std::map< uint32, uint8 > ContextsPriorityInfo;
      /**
       *  Member Functions Declaration
       */
      ContextPriorityHandler(const ContextPriorityHandler& obj);
      ContextPriorityHandler& operator= (const ContextPriorityHandler& obj);
      ContextsPriorityInfo getContextsPriorityInfo() const;

      inline void clear()
      {
         _contextsPriorityInfo.clear();
      }

      inline void initContextsPriorityInfo()
      {
         _contextsPriorityInfo = getContextsPriorityInfo();
      }
      /**
       *  Member Variables Declaration
       */
      ContextsPriorityInfo _contextsPriorityInfo;
};


} //namespace Core
} //namespace App


#endif /* CONTEXT_PRIORITY_HANDLER_H */
