/**
 * @file         : VideoMixConnectionController.h
 * @author       : INF4CV - mve8cob
 * @addtogroup   : AppHmi_Master
 * @brief        : Controls connection/disconnection of cabin sources to
 *                 glass A2 sink
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef VIDEOMIXCONTROLLER_H
#define VIDEOMIXCONTROLLER_H


#include <asf/core/Types.h>
#include "CabinConnectionControllerInterface.h"


namespace App {
namespace Core {


class VideoMixController : public ICabinConnectionController
{
   public:
      /**
       *  Member Functions Declaration
       */
      VideoMixController();
      virtual ~VideoMixController();
      bool onSourceConnect(CabinConnectionHandlerInfo& info);
      bool onSourceDisconnect(CabinConnectionHandlerInfo& info);
      void onCMAStatusUpdate(const SystemStatusInfo& info) {}
      void onConnectionRemoved(CabinConnectionHandlerInfo& info) {}
      void onNewConnectionUpdate(CabinConnectionHandlerInfo& info);
      void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& /*imp*/) {}
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      void onMapOutActivation(CabinConnectionHandlerInfo& info);
      void onMapOutDeactivation(CabinConnectionHandlerInfo& info);
#endif

      inline void setCabinConnectionUtility(CabinConnectionUtility& imp)
      {
         _cabinConnectionUtility = (&imp);
      }

   private:
      /**
       *  Member Functions Declaration
       */
      SinkIdsInfo getSupportedGlassSinksInfo(const uint32 regionId) const;
      uint32 getRegionIdForSinkId(const int16 sinkId) const;
      bool isGlassSinkSupported(const int16 sinkId) const;
      /**
       *  Member Variables Declaration
       */
      CabinConnectionUtility* _cabinConnectionUtility;
};


} //namespace Core
} //namespace App


#endif //VIDEOMIXCONTROLLER_H
