/**
 * @file         : CabinsActivityInfoDpHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinsActivityInfoDpHandlerInterface is to handle the CabinsActivityInfoDpHandler
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABIN_ACTIVITY_INFO_DP_HANDLER_INTERFACE_H
#define CABIN_ACTIVITY_INFO_DP_HANDLER_INTERFACE_H


#include <deque>
#include <vector>
#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

class CabinActivityInfoDPHolder;


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


typedef ::std::deque< CabinActivityInfoDPHolder > CabinsActivitiesInfo;
typedef ::std::vector < CabinActivityInfoDPHolder > CabinActivitiesInfo;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ICabinActivityInfoUpdater
{
   public:
      /**
       *  Member Functions Declaration
       */
      ICabinActivityInfoUpdater() {}
      virtual ~ICabinActivityInfoUpdater() {}
};


class ICabinsActivityInfoDpHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      ICabinsActivityInfoDpHandler() {}
      virtual ~ICabinsActivityInfoDpHandler() {}
      virtual CabinActivitiesInfo getCabinActivitiesInfo(const uint32 cabinId) = 0;
      virtual void clear() = 0;
      virtual void prepareDPUpdate(ICabinActivityInfoUpdater& imp) = 0;
      virtual void finalizeDPUpdate(ICabinActivityInfoUpdater& imp) = 0;
      virtual void updateDPData(ICabinActivityInfoUpdater& imp, const CabinActivityInfoDPHolder& newCabinsActivityInfo) = 0;
};


} //namespace Core
} //namespace App


#endif /* CABIN_ACTIVITY_INFO_DP_HANDLER_INTERFACE_H */
