/**
 * @file         : CabinVideoMixInfoDpHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinVideoMixInfoDpHandlerInterface is to handle the CabinVideoMixInfoDpHandler
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABIN_VIDEO_MIX_INFO_DP_HANDLER_INTERFACE_H
#define CABIN_VIDEO_MIX_INFO_DP_HANDLER_INTERFACE_H


#include <deque>
#include <vector>
#include <asf/core/Types.h>
#include "ProjectBaseTypes.h"

/**
 *  Classes Forward Declaration
 */

class CabinVideoMixInfoHolder;


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


typedef ::std::deque< CabinVideoMixInfoHolder > CabinsVideoMixInfoHolder;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ICabinVideoMixInfoDpHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      ICabinVideoMixInfoDpHandler() {}
      virtual ~ICabinVideoMixInfoDpHandler() {}
      virtual const CabinsVideoMixInfoHolder& getCabinsVideoMixInfo() const = 0;
      virtual const enCabinVideoMixIndex getVideoMixIndexForCabin(const uint32 cabinId) const = 0;
      virtual const CabinVideoMixInfoHolder* getVideoMixInfoForCabin(const uint32 cabinId) const = 0;
      virtual void updateCabinVideoMixDPData(const CabinVideoMixInfoHolder& newCabinVideoMixInfo) = 0;
};


} //namespace Core
} //namespace App


#endif /* CABIN_VIDEO_MIX_INFO_DP_HANDLER_INTERFACE_H */
