/****************************************************************************
* Copyright (c) 2019-2019 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CabinSrcInfo.h
* COMPONENT Name      : AppHmi_Master
* DESCRIPTION         : Provides information about the sources supported in cabin regions
* AUTHOR              : Preethi Alagappan
* Date                : 12.02.2019
* Revision History    : 0.1
* Date 12.02.2019     : Initial version
****************************************************************************/

#ifndef CABINSRCINFO_H
#define CABINSRCINFO_H

#include "AudioDefines.h"  // Definition of source/sink Ids
#include "AppHmi_MasterTypes.h"


namespace App {
namespace Core {


class CabinSrcInfo
{
   public:

      enum SrcType
      {
         COCKPIT_SOURCE,
         CABIN_AV_SOURCE,
         CABIN_VIDEO_SOURCE,
         CABIN_MIX_SOURCE,
         CABIN_AUDIO_SOURCE,
         SRC_TYPE_UNKNOWN
      };

      enum CameraPortID
      {
         CAMERAPORT1 = 0,
         CAMERAPORT2 = 1,
         CAMERAPORT3 = 2,
         CAMERAPORT4 = 3,
         MAX_CAMERAPORTS = 4
      };

      enum MixSrcIndex
      {
         NO_MixSource,
         MIC2_MixSource,
         MIC3_MixSource
      };

      static const int MAX_SRCS_IN_CAMERAPORT = 8;
      static const int nCameraPortSources[MAX_CAMERAPORTS][MAX_SRCS_IN_CAMERAPORT];

      static SrcType getSrcType(int nSrcId);
      static uint8_t getPluginSourceIndex(uint32_t nSrcId);
      static bool isCockpitSource(int SrcId);
      static bool isAVSource(int nSrcId);
      static bool isVideoSource(int nSrcId);
      static bool isCamportHDMI(int nSrcId);
      static bool isCamportUSB(int nSrcId);
      static bool isHUTunerSource(int nSrcId);
      static bool isIPCameraSource(int nSrcId);
      static bool isCMRVideoSource(int nSrcId);
      static bool isCMRAudioSource(int nSrcId);
      static CameraPortID getCameraPortID(int nCameraPortSrcId);
      static bool isMIXSource(int nSrcId);
      static int getMixSrcIndex(int nSrcId);
      static bool isCabinAudioSource(int nsrcId);
      static enCabinActiviyType getActivityTypeForSource(int nSrcId);
};


} //namespace Core
} //namespace App


#endif	// End of CABINSRCINFO_H
