/**
 * @file         : CabinRestorationHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinRestorationHandlerInterface is to handle the CabinRestorationHandler
 *                 feature interfaces implementation
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABIN_RESTORATIONHANDLER_INTERFACE_H
#define CABIN_RESTORATIONHANDLER_INTERFACE_H


#include "CabinRestorationHandlerConstants.h"
#include <Core/RegionHandling/RegionHandlingConstants.h>


/**
 *  Classes Forward Declaration
 */

class IHmiInfoServiceServerComponent;


namespace App {
namespace Core {


class IRegionHandling;
class IHmiStateHandler;
class ISyncDisplayHandler;
class ICabinConnectionHandler;
class ICabinVideoMixInfoDpHandler;
class ICabinsActivityInfoDpHandler;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ICabinRestorationHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      ICabinRestorationHandler() {}
      virtual ~ICabinRestorationHandler() {}
      virtual void finalize() = 0;
      virtual void initialize() = 0;
      virtual void setRegionHandling(IRegionHandling& imp) = 0;
      virtual void setHMIStateHandler(IHmiStateHandler& imp) = 0;
      virtual void setSyncDisplayHandler(ISyncDisplayHandler& imp) = 0;
      virtual void setCabinConnectionHandler(ICabinConnectionHandler& imp) = 0;
      virtual void setCabinVideoMixInfoDpHandler(ICabinVideoMixInfoDpHandler& imp) = 0;
      virtual void setCabinsActivityInfoDpHandler(ICabinsActivityInfoDpHandler& imp) = 0;
      virtual void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& imp) = 0;
      virtual void onUserInteraction(const uint8 regionId, const uint32 sinkId) = 0;
      virtual void onUserInteraction(const uint8 regionId, const SinkIdsInfo sinkIds) = 0;
      virtual uint8 getSinkRestoreStatus(const uint8 sinkId, const uint8 regionId, const uint8 group = SINKGROUP_NONE) = 0;
};


} //namespace Core
} //namespace App


#endif /* CABIN_RESTORATIONHANDLER_INTERFACE_H */
