/**
 * @file         : CabinRestorationHandlerConstants.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinRestorationHandlerConstants is to handle the CabinRestorationHandler
 *                 feature constants implementation
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABIN_RESTORATIONHANDLER_CONSTANTS_H
#define CABIN_RESTORATIONHANDLER_CONSTANTS_H


#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class RestoreSinkInfo;
class RestoreRegionInfo;
class ActivityRestoreSinksInfo;
} //namespace Core
} //namespace App


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


typedef ::std::vector < RestoreSinkInfo > RestoreSinksInfo;
typedef ::std::vector < RestoreRegionInfo > RestoreRegionsInfo;

/* INFO:
 *  -> Param1: SinkGroup
 *  -> Param2: RestoreSinksInfo
 */
typedef ::std::map <uint8, RestoreSinksInfo> RestoreSinksInfoGroup;

/* INFO:
 *  -> Param1: SystemId
 *  -> Param2: SystemStatus
 */
typedef ::std::vector< ::std::pair< uint8, bool > > SystemsStatusInfo;
typedef ::std::vector< ActivityRestoreSinksInfo > ActivitiesRestoreSinksInfo;

enum SinkGroup
{
   SINKGROUP_CABIN     = 0,
   SINKGROUP_VIDEOMIX,
   SINKGROUP_NONE
};


} //namespace Core
} //namespace App


#endif /* CABIN_RESTORATIONHANDLER_CONSTANTS_H */
