/**
 * @file         : CabinConnectionHandlerConstants.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinConnectionHandlerConstants contains typedefs, constants used in CabinConnectionHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABINCONNECTIONHANDLER_CONSTATNTS_H
#define CABINCONNECTIONHANDLER_CONSTATNTS_H

#include <map>
#include <vector>
#include "ProjectBaseTypes.h"
#include "IHmiAudioServiceStubHandler.h"

/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class SinkMapOutInfo;
class RegionMapOutInfo;
class ICabinConnectionController;
} //namespace Core
} //namespace App


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


typedef ::std::map< uint32, bool > MonoModeInfo;

typedef ::std::vector< ICabinConnectionController* > CabinConnectionControllersInfo;

//INFO: Maps cabin sink id with information of source connected to this sink
typedef ::std::vector< hmibase::apphmi_master::audio::stSourceInfo > RequestsQueueInfo;
typedef ::std::map< int16, hmibase::apphmi_master::audio::stSourceInfo > SinkConnectionMap;

#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
typedef ::std::vector< SinkMapOutInfo > SinksMapOutInfo;
typedef ::std::vector< RegionMapOutInfo > RegionsMapOutInfo;
#endif /* VARIANT_S_FTR_ENABLE_MAP_STREAMING */
} //namespace Core
} //namespace App


#endif//CABINCONNECTIONHANDLER_CONSTANTS_H
