/**
 * @file         : CabinConnectionControllerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinConnectionControllerInterface is to handle the CabinConnectionController
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABINCONNECTIONCONTROLLER_INTERFACE_H
#define CABINCONNECTIONCONTROLLER_INTERFACE_H


#include "CabinConnectionHandlerDefines.h"
#include "CabinConnectionHandlerConstants.h"
#include <Core/RegionHandling/RegionHandlingConstants.h>


/**
 *  Classes Forward Declaration
 */

class CabinActivityInfoDPHolder;
class IHmiInfoServiceServerComponent;

namespace App {
namespace Core {


class IRegionHandling;
class SystemStatusInfo;
class VideoMixController;
class CabinConnectionUtility;
class ICabinConnectionHandler;
class ICabinRestorationHandler;
class CabinConnectionHandlerInfo;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ICabinConnectionController
{
   public:
      /**
       *  Member Function Declaration
       */
      ICabinConnectionController() {}
      virtual ~ICabinConnectionController() {}
      virtual bool onSourceConnect(CabinConnectionHandlerInfo& info) = 0;
      virtual bool onSourceDisconnect(CabinConnectionHandlerInfo& info) = 0;
      virtual void onCMAStatusUpdate(const SystemStatusInfo& info) = 0;
      virtual void onConnectionRemoved(CabinConnectionHandlerInfo& info) = 0;
      virtual void setCabinConnectionUtility(CabinConnectionUtility& imp) = 0;
      virtual void onNewConnectionUpdate(CabinConnectionHandlerInfo& info) = 0;
      virtual void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& imp) = 0;
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      virtual void onMapOutActivation(CabinConnectionHandlerInfo& info) = 0;
      virtual void onMapOutDeactivation(CabinConnectionHandlerInfo& info) = 0;
#endif
};


} //namespace Core
} //namespace App


#endif /* CABINCONNECTIONCONTROLLER_INTERFACE_H */
