/**************************************************************************************
* @file         : BTCLIENTHANDLER.h
* @author       : ECG5 - vta5kor
* @addtogroup   : AppHmi_Master
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef BTCLIENTHANDLER_H_
#define BTCLIENTHANDLER_H_


#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
//#include "DataModel/HMIModelComponent.h"


class StartupSync;

namespace App {
namespace Core {

class BTClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::MOST_BTSet_FI::BluetoothOnOffCallbackIF
{
   public:

      BTClientHandler();
      virtual ~BTClientHandler();

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                      const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                        const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >&, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >&);

      virtual void onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >&, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >&);
      bool getBTStatus();
      static BTClientHandler* poGetInstance()
      {
         if (NULL == _btClientHandler)
         {
            _btClientHandler = new BTClientHandler();
         }

         return _btClientHandler;
      }

   private:
      bool m_bBluetoothAvailability;
      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSettingProxy;
      static BTClientHandler* _btClientHandler;
};


}
}


#endif /* BTCLIENTHANDLER_H_ */
