/**
 * @file         : SoundControllerPrjInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : SoundControllerPrjInterface is to handle the SoundControllerPrj
 *                 feature interfaces implementation
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef SOUND_CONTROLLER_PRJ_INTERFACE_H
#define SOUND_CONTROLLER_PRJ_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

class IMuteStateListenerCB;
class IVolumeChangeListenerCB;
class ISoundPropertyListenerCB;


/**
 *  Classes Declaration
 */

class ISoundControllerPrj
{
   public:
      /**
       *  Member Function Declaration
       */
      ISoundControllerPrj() {}
      virtual ~ISoundControllerPrj() {}
      virtual void addMuteStateListener(IMuteStateListenerCB& imp) = 0;
      virtual void removeMuteStateListener(IMuteStateListenerCB& imp) = 0;
      virtual void addVolumeChangeListener(IVolumeChangeListenerCB& imp) = 0;
      virtual void removeVolumeChangeListener(IVolumeChangeListenerCB& imp) = 0;
      virtual void addSoundPropertyListener(ISoundPropertyListenerCB& imp) = 0;
      virtual void removeSoundPropertyListener(ISoundPropertyListenerCB& imp) = 0;
};


class IMuteStateListenerCB
{
   public:
      /**
       *  Member Function Declaration
       */
      IMuteStateListenerCB() {}
      virtual ~IMuteStateListenerCB() {}
      virtual void onMuteStateUpdate(const uint32 sinkId, const int state) = 0;
};


class IVolumeChangeListenerCB
{
   public:
      /**
       *  Member Function Declaration
       */
      IVolumeChangeListenerCB() {}
      virtual ~IVolumeChangeListenerCB() {}
      virtual void onVolumeChangeUpdate(const uint32 sinkId, const int volume) = 0;
};


class ISoundPropertyListenerCB
{
   public:
      /**
       *  Member Function Declaration
       */
      ISoundPropertyListenerCB() {}
      virtual ~ISoundPropertyListenerCB() {}
      virtual void onSoundPropertyUpdate(const int16 nSinkId) = 0;
};


#endif /* SOUND_CONTROLLER_PRJ_INTERFACE_H */
