/**
 * @file         : ResourceControllerPrjInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ResourceControllerPrjInterface is to handle the ResourceControllerPrj
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef RESOURCE_CONTROLLER_PRJ_INTERFACE_H
#define RESOURCE_CONTROLLER_PRJ_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

class IUpdateSourceListListenerCB;
class IUpdateSinkListenerCB;


/**
 *  Classes Declaration
 */

class IResourceControllerPrj
{
   public:
      /**
       *  Member Function Declaration
       */
      IResourceControllerPrj() {}
      virtual ~IResourceControllerPrj() {}
      virtual int32 getSourceAvailability(const int32 srcIndex) = 0;
      virtual int32 getSourceAvailability(const int32 srcIndex, const int32 deviceId) = 0;
      virtual bool isSinkAdded(const int sinkIndex) = 0;
      virtual bool isMainSource(const uint32 sourceId) = 0;
      virtual bool isSourceAvailable(const int32 srcIndex) = 0;
      virtual bool isAnnouncementSource(const uint32 sourceId) = 0;
      virtual bool isSourceAvailable(const int32 srcIndex, const int32 deviceId) = 0;
      virtual void addSourceListUpdateListener(IUpdateSourceListListenerCB& imp) = 0;
      virtual void removeSourceListUpdateListener(IUpdateSourceListListenerCB& imp) = 0;
      virtual void addSinkUpdateListener(IUpdateSinkListenerCB& imp) = 0;
      virtual void removeSinkUpdateListener(IUpdateSinkListenerCB& imp) = 0;
};


class IUpdateSourceListListenerCB
{
   public:
      /**
       *  Member Function Declaration
       */
      IUpdateSourceListListenerCB() {}
      virtual ~IUpdateSourceListListenerCB() {}
      virtual void onUpdateSourceListChange(const uint32 srcIndex) = 0;
};


class IUpdateSinkListenerCB
{
   public:
      /**
       *  Member Function Declaration
       */
      IUpdateSinkListenerCB() {}
      virtual ~IUpdateSinkListenerCB() {}
      virtual void onUpdateSinkChange(const uint32 sinkIndex) = 0;
};


#endif /* RESOURCE_CONTROLLER_PRJ_INTERFACE_H */
