/**
 * @file         : ResourceControllerPrj.cpp
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ResourceControllerPrj is project extension of HMIBase ResourceController
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "hall_std_if.h"
#include "AudioInterfaceHelper.h"
#include "ResourceControllerPrj.h"
#include <AppHmi_MasterBase/AudioInterface/Source.h>
#include <AppHmi_MasterBase/AudioInterface/AudioDefines.h>
#include <AppHmi_MasterBase/AudioInterface/AudioControllerObjectManager.h>


using namespace ::hmibase::apphmi_master::audio;
using namespace ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_MASTER_MAIN
#include "trcGenProj/Header/ResourceControllerPrj.cpp.trc.h"
#endif


ResourceControllerPrj::ResourceControllerPrj()
{
   ETG_TRACE_USR4(("ResourceControllerPrj::constructor called "));
}


ResourceControllerPrj::~ResourceControllerPrj()
{
   ETG_TRACE_USR4(("ResourceControllerPrj::destructor called "));
}


void ResourceControllerPrj::UpdateSourceListChange(int32 nSrcIndex)
{
   ResourceController::UpdateSourceListChange(nSrcIndex);
   for (::std::vector< IUpdateSourceListListenerCB* >::const_iterator itr = _sourceListUpdateListeners.begin(); (itr != _sourceListUpdateListeners.end()); ++itr)
   {
      if (NULL != (*itr))
      {
         (*itr)->onUpdateSourceListChange(nSrcIndex);
      }
   }
}


void ResourceControllerPrj::OnUpdateSink(int nSinkIndex)
{
   ResourceController::OnUpdateSink(nSinkIndex);
   for (::std::vector< IUpdateSinkListenerCB* >::const_iterator itr = _sinkUpdateListeners.begin(); (itr != _sinkUpdateListeners.end()); ++itr)
   {
      if (NULL != (*itr))
      {
         (*itr)->onUpdateSinkChange(nSinkIndex);
      }
   }
}


int32 ResourceControllerPrj::getSourceAvailability(const int32 srcIndex, const int32 deviceId)
{
   int32 tGrpIndex     = getGroupIndexForSource(srcIndex);
   int32 tAvailability = RES_UNKNOWN;
   if (tGrpIndex < SRC_INVALID)
   {
      ::std::vector< sourceDetails > tSrcList;
      ResourceController::GetGroupSrcList(tGrpIndex, (&tSrcList));
      for (::std::vector< sourceDetails >::const_iterator itr = tSrcList.begin(); (itr != tSrcList.end()); ++itr)
      {
         if (((*itr).getSrcId() == srcIndex) && (deviceId == (*itr).getSubSrcId()))
         {
            tAvailability = (*itr).getAvailability();
            break;
         }
      }
   }
   return tAvailability;
}


bool ResourceControllerPrj::isSinkAdded(const int sinkIndex)
{
   bool isSinkAdded = false;
   Sink* pSink = NULL;
   ResourceController* pResourceController = AudioControllerObjectManager::getInstance().getResourceController<ResourceController>().get();
   if (pResourceController != NULL)
   {
      pResourceController->mapSinkIdx(sinkIndex);
      pSink = pResourceController->GetSinkOnIdx();
   }
   if (pSink != NULL)
   {
      isSinkAdded = true;
   }
   return isSinkAdded;
}


bool ResourceControllerPrj::isMainSource(const uint32 sourceId)
{
   return (SrcMap::getSrcMapInstance()->getSourceType(sourceId) == SOURCE_MAIN) ? true : false;
}


bool ResourceControllerPrj::isAnnouncementSource(const uint32 sourceId)
{
   return (SrcMap::getSrcMapInstance()->getSourceType(sourceId) == SOURCE_ANNOUNCEMENT) ? true : false;
}


int32 ResourceControllerPrj::getSourceAvailability(const int32 srcIndex)
{
   int32 tGrpIndex     = getGroupIndexForSource(srcIndex);
   int32 tAvailability = RES_UNKNOWN;
   if (tGrpIndex < SRC_INVALID)
   {
      ::std::vector< sourceDetails > tSrcList;
      ResourceController::GetGroupSrcList(tGrpIndex, (&tSrcList));
      for (::std::vector< sourceDetails >::const_iterator itr = tSrcList.begin(); (itr != tSrcList.end()); ++itr)
      {
         if ((*itr).getSrcId() == srcIndex)
         {
            tAvailability = (*itr).getAvailability();
            break;
         }
      }
   }
   return tAvailability;
}
