/**
 * @file         : ConnectionControllerPrjInterfaces.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ConnectionControllerPrjInterfaces is to handle the ConnectionControllerPrj
 *                 interfaces implementation
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef ICONNECTIONCONTROLLER_PRJ_H
#define ICONNECTIONCONTROLLER_PRJ_H


#include "AppHmi_MasterBase/AudioInterface/ConnectionController.h"


#define NS_MASTER_AUDIO ::hmibase::apphmi_master::audio


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
class ICabinConnectionHandler;
#endif
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

class IConnectionInfoUpdate
{
   public:
      /**
       *  Member Function Declaration
       */
      IConnectionInfoUpdate() {};
      virtual ~IConnectionInfoUpdate() {};
      virtual void onUpdateConnectionInfo(std::map< int, NS_MASTER_AUDIO::Connection* > info) = 0;
};


class IConnectionControllerPrj
{
   public:
      /**
       *  Member Function Declaration
       */
      IConnectionControllerPrj() {}
      virtual ~IConnectionControllerPrj() {}
      virtual int16 getPrivateSpeakerSinkId() = 0;
      virtual int16 getCurrentActiveSource(const int16 sinkId) = 0;
      virtual int16 getActiveSourceIdOnSink(const int16 sinkId) = 0;
      virtual int16 getCurrentActiveAnnouncementSource(const int16 sinkId) = 0;
      virtual bool fetchCurrentActiveSource(const int16 sinkId, int& srcIndex, int& srcDeviceId) = 0;
      virtual void vRegisterforConnectionInfoUpdate(IConnectionInfoUpdate* client) = 0;
      virtual void vUnRegisterforConnectionInfoUpdate(IConnectionInfoUpdate* client) = 0;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      virtual void setCabinConnectionHandler(::App::Core::ICabinConnectionHandler& imp) = 0;
      virtual bool sendCabinSourceRequest(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID) = 0;
      virtual void sendCabinSourceDisconnect(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID) = 0;
#endif
};


#undef NS_MASTER_AUDIO


#endif /* ICONNECTIONCONTROLLER_PRJ_H */
