/**
 * @file         : AudioInterfaceHelper.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : AudioInterfaceHelper is to handle the Audio Interface
 *                 feature helper implementation
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef AUDIO_INTERFACE_HELPER_H
#define AUDIO_INTERFACE_HELPER_H


#include "ProjectBaseTypes.h"
#include <asf/core/Types.h>


/**
 *  Member Functions (like "C")
 */

int32 getGroupIndexForSource(const int32 srcIndex);
enApplicationId getApplicationIdForSrc(const int32 srcIndex);
enApplicationId getApplicationIdForGroup(const int32 grpIndex);


#endif /* AUDIO_INTERFACE_HELPER_H */
