/**
 * @file         : AudioInterfaceHelper.cpp
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : AudioInterfaceHelper is to handle the Audio Interface
 *                 feature helper implementation
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "AudioInterfaceHelper.h"
#include <AppHmi_MasterBase/AudioInterface/AudioDefines.h>


/**
 *  Member Functions (like "C")
 */

int32 getGroupIndexForSource(const int32 srcIndex)
{
   int32 tGrp = SRC_INVALID;
   if (srcIndex < SRC_INVALID)
   {
      tGrp = srcIndex / SRC_GROUP_SIZE;
   }
   return tGrp;
}


enApplicationId getApplicationIdForGroup(const int32 grpIndex)
{
   enApplicationId tAppId = APPID_APPHMI_UNKNOWN;
   switch (grpIndex)
   {
      case GROUP_TUNER:
      {
         tAppId = APPID_APPHMI_TUNER;
         break;
      }
      case GROUP_PHONE:
      {
         tAppId = APPID_APPHMI_PHONE;
         break;
      }
      case GROUP_MEDIA:
      {
         tAppId = APPID_APPHMI_MEDIA;
         break;
      }
      default:
         break;
   }
   return tAppId;
}


enApplicationId getApplicationIdForSrc(const int32 srcIndex)
{
   enApplicationId tAppId = APPID_APPHMI_UNKNOWN;
   switch (getGroupIndexForSource(srcIndex))
   {
      case GROUP_TUNER:
      {
         tAppId = (srcIndex == SRC_TUNER_XM) ? APPID_APPHMI_SXM : APPID_APPHMI_TUNER;
         break;
      }
      case GROUP_PHONE:
      {
         tAppId = APPID_APPHMI_PHONE;
         break;
      }
      case GROUP_MEDIA:
      {
         tAppId = APPID_APPHMI_MEDIA;
         break;
      }
      case GROUP_OTHERS:
      {
         switch (srcIndex)
         {
            case SRC_CAMERAPORT1_HDMI:
            case SRC_CAMERAPORT2_HDMI:
            case SRC_CAMERAPORT3_HDMI:
            case SRC_CAMERAPORT1_USB_VIDEO:
            case SRC_CAMERAPORT2_USB_VIDEO:
            case SRC_CAMERAPORT1_USB_AUDIO:
            case SRC_CMR1_USB1_VIDEO:
            case SRC_CMR1_USB2_VIDEO:
            case SRC_CMR1_USB1_AUDIO:
            case SRC_CMR1_USB2_AUDIO:
            {
               tAppId = APPID_APPHMI_MEDIA;
               break;
            }
         }
         break;
      }
      default:
         break;
   }
   return tAppId;
}
