/**
 * @file         : ApplicationSwitchServerComponent.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ApplicationSwitchServerComponent is extention of ApplicationSwitchStub
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef APPLICATION_SWITCH_SERVER_COMPONENT_H
#define APPLICATION_SWITCH_SERVER_COMPONENT_H


#include "ApplicationSwitchStub.h"
#include "ApplicationSwitchConst.h"
#include "ApplicationSwitchServerComponentInterface.h"


/**
 *  Defines Declaration
 */

#define NS_APPLICATION_SWITCH    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ApplicationSwitchServerComponent : public IApplicationSwitchServerComponent
   , public NS_APPLICATION_SWITCH::ApplicationSwitchStub
{
   public:
      /**
       *  Member Functions Declaration
       */
      ApplicationSwitchServerComponent();
      virtual ~ApplicationSwitchServerComponent();
      void onSendContextRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::SendContextRequest >& request);
      void onDisplayAppFlyInReqRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::DisplayAppFlyInReqRequest >& request);
      void onSpi_ForwardEncoderRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::Spi_ForwardEncoderRequest >& request);
      void onSpi_connectionstatusRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::Spi_connectionstatusRequest >& request);
      void onRequestContextSwitchRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::RequestContextSwitchRequest >& request);
      void onRequestApplcationSwitchRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::RequestApplcationSwitchRequest >& request);
      void onRequestShowHideWaitSceneRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::RequestShowHideWaitSceneRequest >& request);
      void onSpeechSession_activated_deactivatedRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::SpeechSession_activated_deactivatedRequest >& request);
      void onMapout_activated_deactivatedRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::Mapout_activated_deactivatedRequest >& request);
      void onActivateDeactivateRVCSceneRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::ActivateDeactivateRVCSceneRequest >& request);
      void onConfigureAppFlyInStatusRequest(const ::boost::shared_ptr< NS_APPLICATION_SWITCH::ConfigureAppFlyInStatusRequest >& request);
      void sendSWCKeyEventSignal(const uint32 event);
      void sendControlPanelButtonPressUpdateSignal(const uint8 buttonId, const uint8 buttonState, const uint32 receiverAppID);
      void sendSpeechSessionSignal(const bool status);
      void sendSPIVoiceRecognitionSignal(const uint32 event);
      void sendRegionChangePropertyUpdate(const uint32 regionId);
      void sendMapOutSignal(const uint32 regionId, const bool status);
      void sendActivateContextSignal(const uint32 regionId, const uint32 appId, const uint32 contextId);

      inline void setRegionHandling(IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setContextSwitchHandler(IContextSwitchHandler& imp)
      {
         _contextSwitchHandler = (&imp);
      }

      inline void setHmiInfoServiceServerComponent(HmiInfoServiceServerComponent& imp)
      {
         _hmiInfoServiceServerComponent = (&imp);
      }

      inline void setAppFlyIn(AppFlyIn& imp)
      {
         _appFlyIn = (&imp);
      }

   private:
      /**
       *  Member Functions Declaration
       */
      ApplicationSwitchServerComponent(const ApplicationSwitchServerComponent& obj);
      ApplicationSwitchServerComponent& operator = (const ApplicationSwitchServerComponent& obj);
      /**
       *  Member Variables Declaration
       */
      bool _speechStatus;
      IRegionHandling* _regionHandling;
      IContextSwitchHandler* _contextSwitchHandler;
      HmiInfoServiceServerComponent* _hmiInfoServiceServerComponent;
      AppFlyIn* _appFlyIn;
};


} //namespace Core
} //namespace App


#endif /* APPLICATION_SWITCH_SERVER_COMPONENT_H */
