/* ***************************************************************************************
* FILE:          AppFlyIn.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppFlyIn.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _APPFLYIN_H
#define _APPFLYIN_H

#include "AppFlyInTypes.h"
#include "AppFlyInDefines.h"
#include "ApplicationSwitch.h"
#include "AppHmi_MasterStateMachine.h"
#include "Common/DataModel/ListRegistry.h"
#include <Core/VariantHandling/VariantHandling.h>
#include <Core/RegionHandling/RegionHandlingInterface.h>
#include <Core/ContextSwitchHandler/ContextSwitchHandlerInterface.h>


#define APPSWITCH_NAMESPACE bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch


/**
 *  Classes Forward Declaration
 */

class IConnectionControllerPrj;

namespace App {
namespace Core {

class ICabinConnectionHandler;
} //namespace Core
} //namespace App

/**
 *  Classes Declaration
 */


namespace App {
namespace Core {


class AppFlyIn
   : public ListImplementation
   , public ICMAStatusListenerCB
   , public ICMGStatusListenerCB
   , public IActiveContextListenerCB
{
   public:
      virtual ~AppFlyIn();
      static AppFlyIn* getInstance();
      static void deleteInstance();
      void onActiveContextUpdate(const ApplicationContextInfo& info);
      void onApplicationSwitchComplete(const uint32 appId);
      void onCMAStatusUpdate(const SystemStatusInfo& info);
      void onCMGStatusUpdate(const SystemStatusInfo& info);
      void onAppFlyInButtonStateUpdateRequest(const ::std::vector< ::APPSWITCH_NAMESPACE::AppFlyInStateInfo >& stateInfo);
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(SceneStatusInfoMsg)
      ON_COURIER_MESSAGE(AppFlyInActivationReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      void initialize();
      void finalize();

      inline void setContextSwitchHandler(IContextSwitchHandler& imp)
      {
         _contextSwitchHandler = (&imp);
      }

      inline void setVariantHandling(VariantHandling& imp)
      {
         _variantHandling = (&imp);
      }

      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setConnectionControllerPrj(const ::boost::shared_ptr< IConnectionControllerPrj >& imp)
      {
         _connectionControllerPrj = imp;
      }

#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      inline void setCabinConnectionHandler(ICabinConnectionHandler& imp)
      {
         _cabinConnectionHandler = (&imp);
      }
#endif

   private:
      AppFlyIn();
      AppFlyIn(const AppFlyIn& obj);
      AppFlyIn& operator = (const AppFlyIn& obj);
      void initAppFlyInListDataInfo();
      void initAppFlyInListOrderInfo();
      void initApplicationContextInfo();
      void updateMapOutAppFlyInStatus(const uint32 regionId);
      bool onCourierMessage(const SceneStatusInfoMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const AppFlyInActivationReqMsg& oMsg);
      bool isValidContextForApplication(const uint32 appId, const uint32 contextId) const;
      ::std::map < uint32, AppFlyInsInfo > getCoachListInfo() const;
      ::std::map < uint32, AppFlyInsInfo > getTruckListInfo() const;
      ::std::map < uint32, AppFlyInsInfo > getSmartListInfo() const;
      ::std::map < uint32, AppFlyInsOrderInfo > getSmartListOrder() const;
      ::std::map < uint32, AppFlyInsOrderInfo > getCoachListOrder() const;
      ::std::map < uint32, AppFlyInsOrderInfo > getTruckListOrder() const;
      ::std::map <uint32, ::std::vector <uint32> > getApplicationContextInfo() const;
      AppFlyInItemInfo* getAppFlyInItemInfo(const uint32 listId, const uint32 regionId);
      AppFlyInItemOrder* getAppFlyInItemOrder(const uint32 listId, const uint32 regionId, const uint32 appId);
      void performMapoutButtonPress(const uint32 regionId);
      void performListButtonPress(const uint32 listId, const uint32 regionId, const uint8 index);
      void performTunerMediaButtonPress(const uint32 listId, const uint32 regionId, const uint8 index);
      void performDefaultContextSwitchRequest(const uint32 listId, const uint32 regionId, const uint8 index);

      static AppFlyIn* _theModelInstance;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      ICabinConnectionHandler* _cabinConnectionHandler;
#endif
      IContextSwitchHandler* _contextSwitchHandler;
      VariantHandling* _variantHandling;
      IRegionHandling* _regionHandling;
      ::boost::shared_ptr< IConnectionControllerPrj > _connectionControllerPrj;
      enSceneStatus _sceneStatus;
      ::std::map < uint32, AppFlyInsInfo > _appFlyInDataInfo;
      ::std::map < uint32, AppFlyInsOrderInfo > _appFlyInOrderInfo;
      ::std::map <uint32, ::std::vector <uint32> > _appContextInfo;
};


}
}


#undef APPSWITCH_NAMESPACE

#endif // _APPFLYIN_H
