/**
 * @file        :  CGIAppViewFactory.cpp
 * @addtogroup  :  AppHmi_Camera
 * @brief       :  SXM HALL class which contains all the necessary business logic required for CGI App
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "CGIAppViewFactory.h"
#include "AppHmi_CameraMessages.h"
// the views
#include "CGIAppViewController_Camera.h"
#include "CgiExtensions/ViewScene2D.h"
/*-------------------------------------*/
/**
* RenderTargetInvalidatingViewScene is derived from ViewSceneBase.
* This class is used to invalidate the scene
*.
*
*/

SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraSourceSelection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraStream),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraStream_CAN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraRearView),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraCabinView),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraCabinSourceSelection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_CAM_GADGET),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_CAM_GADGET_NON_NAVI),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_CameraHomeScreen_Cabin),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_CameraHomeScreen_Cabin_Non_Navi),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Camera_Warning_Popup),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Camera_Not_configured),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraSplitScene),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_C_CameraFullSplit),

// simple view controller from AppHmi_Tuner_SimpleViewController.h have not to be added here
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}


/****************************EOF***********************/
