/**
 * @file        :  CGIAppViewController_Camera.h
 * @addtogroup  :  AppHmi_Camera
 * @brief       :  Receive messages subscribed with 'View' here, when it has not been consumed by any widget
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#if !defined (_CGIAPPVIEWCONTROLLER_TESTMODE_H)
#define _CGIAPPVIEWCONTROLLER_TESTMODE_H
#include "CgiExtensions/CourierMessageMapper.h"
/**
* tController is the template for the classes
* to be created for the newly added scene. Each
*.new scene added will have to add new declaration
* as shown below.
*/
#define SIMPLE_CONTROLLER(tController)\
class tController : public ViewControllerBase\
{\
   private:\
   courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
   public:\
      tController() {}\
      virtual ~tController() {}\
      static const char* _name;\
      static Courier::ViewController* createInstance()\
      {\
         return COURIER_NEW(tController)();\
      }\
};


//Scenes
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraSourceSelection)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraStream)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraStream_CAN)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraRearView)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraCabinView)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraCabinSourceSelection)
SIMPLE_CONTROLLER(CGIAppViewController_CAM_GADGET)
SIMPLE_CONTROLLER(CGIAppViewController_CAM_GADGET_NON_NAVI)
SIMPLE_CONTROLLER(CGIAppViewController_CameraHomeScreen_Cabin)
SIMPLE_CONTROLLER(CGIAppViewController_CameraHomeScreen_Cabin_Non_Navi)
SIMPLE_CONTROLLER(CGIAppViewController_Camera_Warning_Popup)
SIMPLE_CONTROLLER(CGIAppViewController_Camera_LoadingAnimation)
SIMPLE_CONTROLLER(CGIAppViewController_Camera_Not_configured)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraSplitScene)
SIMPLE_CONTROLLER(CGIAppViewController_C_CameraFullSplit)
#endif // _CGIAPPVIEWCONTROLLER_TESTMODE_H
