/**
 * @file        :  CGIAppPopupTable.cpp
 * @addtogroup  :  AppHmi_Camera
 * @brief       :  Camera HALL class which contains all the necessary business logic required for CGI App popup table
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"
#include "CGIAppViewController_Camera.h"

POPUP_TABLE_BEGIN()
//                popup ID,                     modality,                           prio, presentation time, min. presentation time, validity period, close on superseded, close on app leave, surface ID, path in asset

POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 11, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_CAMERA, CGIAppViewController_C_CameraStream_CAN),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 13, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_CAMERA, CGIAppViewController_Camera_Warning_Popup),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 13, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_CAMERA, CGIAppViewController_Camera_Not_configured),
                  POPUP_TABLE_END()
