/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CGIAppController.h"
#include "App/Core/CameraMain/CameraMain.h"
#include "AppHmi_CameraStateMachine.h"

#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_CAMERA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Camera_"
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

using namespace App::Core;


bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& msg)
{
   POST_MSG((COURIER_MESSAGE_NEW(ActiveRenderedView)(msg.GetSurfaceId(), msg.GetViewName())));
   return false;
}


bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   bool retVal = false;
   int m_Hkcode = msg.GetHKCode();
   hmibase::HardKeyStateEnum hardkeyState = msg.GetHKState();
   if ((hardkeyState == hmibase::HARDKEYSTATE_UP) && (msg.GetHKCode() == HARDKEYCODE_HK_CAMERA))
   {
      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg ACCEPT HKCode: %d %d", m_Hkcode, hardkeyState));
      POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
   }
   else
   {
      retVal = CGIAppControllerProject::onCourierMessage(msg);
   }
   return retVal;
}
