/**
 * @file        : AppViewSettings.h
 * @addtogroup  : AppHmi_Camera
 * @brief       : If in this class no special handling is defined, the implementation of the
 * 				  base class IAppViewSettings will be used by ScreenBrokerClient
 * @copyright   : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 */
#if !defined(AppViewSettings_h)
#define AppViewSettings_h

#include "AppBase/ScreenBrokerClient/IAppViewSettings.h"
#include "hmibase/util/Singleton.h"


class AppViewSettings : public IAppViewSettings
{
      //Lazy initialization of application view settings singleton
      HMIBASE_SINGLETON_CLASS(AppViewSettings)
};


#endif // AppViewSettings_h
