/**************************************************************************************
* @file         : NanoMsgClientHandler.h
* @author       : RBEI/ECG5-INF4CV
* @addtogroup   : AppHmi_Master
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef NanoMsgClientHandler_h
#define NanoMsgClientHandler_h

#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceProxy.h"
#include "CameraSourceChangeHandler/CameraSourceChangeHandler.h"
#include "CameraMain.h"
#include "CameraListHandler.h"
#include "CameraDataBindingHandler.h"
#include "AppHmi_CameraDatabinding.h"
#include "AVRoutingParser.h"
#include "CameraDefines.h"
#include "asf/core/Timer.h"

using namespace ::asf::core;
using namespace ::bosch::cm::di::NanoMsgGenericInterface;

namespace App {
namespace Core {

typedef struct
{
   uint32 NanoMsgDigPinsVal;
   uint16_t NanoMsgPosition;
   std::string NanoMsgIpAddress;
} NanoMsgDigPinInfo;

class NanoMsgClientHandler : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public Sig_EventDigitalInputCallbackIF
   , public Sig_EventDigitalInputCMPCallbackIF
   , public Sig_RspGetDigitalInputCMPCallbackIF
   , public ReqGetDigitalInputCMPCallbackIF
   , public ::asf::core::TimerCallbackIF
{
   public:

      ~NanoMsgClientHandler();
      static NanoMsgClientHandler* poGetInstance();
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error);

      virtual void onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal);

      virtual void onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error);

      virtual void onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response) ;

      virtual void onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error);

      virtual void onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal);

      virtual void onSig_EventDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPError >& error);
      virtual void onSig_EventDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPSignal >& signal);

      virtual void onSig_RspGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPError >& error);
      virtual void onSig_RspGetDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPSignal >& signal);

      virtual void onReqGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPError >& error);
      virtual void onReqGetDigitalInputCMPResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPResponse >& response);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      CameraDataBindingHandler* m_poCameraDataBindingHandler;
      static void TraceCmd_onCameraNanoStatus(int digitalInput, std::string ipaddress);
      static void TraceCmd_onCameraPopupTimerValue(uint32 PopupTimerValue);
      void HandleNanoStatus(int digitalInput, std::string ipaddress);
      void vNanoMsgSelection(uint32 digitalInputvalue);
      int getPosition(std::string ipAddress);
      tclAvRoutingParser* _avRoutingParser;

      //Camera Port [Camera Port Position][Dig Pin Value]
//Camera Port [CMP][D_PIN]
// D_PIN-0 and CMP_0 is dummy
//		     							  D_PIN-0  D_PIN-1  D_PIN-2  D_PIN-3   D_PIN-3
      std::string cameraPortPosSrcName[4][5] = {{"",    ""		,     ""	,    ""	,    ""	   },    //CMP_0
         {"", "CMP1_CAM1", "CMP1_CAM2", "CMP1_CAM3", "CMP1_CAM4"}, //CMP_1
         {"", "CMP2_CAM1", "CMP2_CAM2", "CMP2_CAM3", "CMP2_CAM4"}, //CMP_2
         {"", "CMP3_CAM1", "CMP3_CAM2", "CMP3_CAM3", "CMP3_CAM4"}  //CMP_3
      };

      std::map<int, int> _myMap;
      int getActualDigitalInputValue(uint32 digitalInputvalue);
      std::map<int, int> _nanoDigPinNdPosMapData;

      // void uPdateDigitalInputFlagStatus(bool Rxd_digitalInputReceived);
      bool getDigitalInputFlagStatus();
      void checkNanoMsgDigPinIsActive();

      void updateNanoDigPinNdPosMapData(map<int, int>& Rxd_nanoDigPinNdPosMapData);
      map<int, int> getNanoDigPinNdPosMapData();

      // void verifyNanoMsgDigitalPinAndDisplayRequest();
      void RequestStopCameraSreamNdConextextSwitchOnDigInput();
      void DigPinCamDisplayConditionCheck(uint8 index, uint8 position, uint8 DigPinvalue, std::string strCamSrc);
      uint8 findChannelNoforCamPort(uint32 digitalInput);
      void ProcessDigitalPinData(map<int, int>& RxdRaw_nanoDigPinNdPosMapData);

      /** Instance for the timer */
      asf::core::Timer _digPin_rvcTimer;
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void setpopuptimervalue(uint32 SetPopupTimerValue);
      uint32 getPopupTimerValue();
      void vContextSwitchRequestToCameraScreenViaNanoTrigger();
      void checkDigPinActiveOnSubSystemAvailable();
      uint32 popUpTimervalue;
   private:
      NanoMsgClientHandler();
      static NanoMsgClientHandler* m_poSelfNanoMsg;
      ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> m_poNanoMsgProxy;
      bool digitalInputFlag;

      NanoMsgDigPinInfo NanoMsgDigPinItem[TOTAL_THREE_CMP + 1];
};


}
}


#endif
