#include "NanoMsgClientHandler.h"
#include "hmi_trace_if.h"
#include "CameraConfig/CameraConfig.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_CAMERA_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_Camera_"
#define ETG_I_FILE_PREFIX App::Core::NanoMsgClientHandler::
#include "trcGenProj/Header/NanoMsgClientHandler.cpp.trc.h"
#endif

#define ON_DIG_INP_RVC_TIMEOUT_PROCESS_TIME 3000
using namespace ::bosch::cm::di::NanoMsgGenericInterface;

namespace App {
namespace Core {

NanoMsgClientHandler* NanoMsgClientHandler::m_poSelfNanoMsg = NULL;

NanoMsgClientHandler::NanoMsgClientHandler()
   : m_poNanoMsgProxy(bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy::createProxy("NanoMsgGenericPort", *this)),
     _digPin_rvcTimer(*this, ON_DIG_INP_RVC_TIMEOUT_PROCESS_TIME)
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("NanoMsgClientHandler Constructor is called"));
   digitalInputFlag = false;
   popUpTimervalue = 1;
   // uPdateDigitalInputFlagStatus(digitalInputFlag);
   m_poCameraDataBindingHandler = CameraDataBindingHandler::poGetInstance();
   _avRoutingParser = tclAvRoutingParser::pGetInstance();
   if (_avRoutingParser != NULL)
   {
      bool m_bParseState = _avRoutingParser->bParseXml();
   }
   _myMap[1] = 0;
   _myMap[2] = 0;
   _myMap[3] = 0;

   for (int i = 0; i <= TOTAL_THREE_CMP; i++)
   {
      NanoMsgDigPinItem[i].NanoMsgDigPinsVal = 0;
      NanoMsgDigPinItem[i].NanoMsgPosition   = 0;
      NanoMsgDigPinItem[i].NanoMsgIpAddress  = " ";
      ETG_TRACE_USR4(("NanoMsgClientHandler::NanoMsgClientHandler() Position==>%d||NanoMsgDigPinsVal==>%d ||NanoMsgPosition==>%d || NanoMsgIpAddress.c_str()==>%s ", i, NanoMsgDigPinItem[i].NanoMsgDigPinsVal,  NanoMsgDigPinItem[i].NanoMsgPosition,  NanoMsgDigPinItem[i].NanoMsgIpAddress.c_str()));
   }
}


NanoMsgClientHandler::~NanoMsgClientHandler()
{
   if (NULL != m_poSelfNanoMsg)
   {
      delete m_poSelfNanoMsg;
      m_poSelfNanoMsg = NULL;
   }
}


NanoMsgClientHandler* NanoMsgClientHandler::poGetInstance()
{
   /* No more than one instance of NanoMsgClientHandler should be created */
   if (NULL == m_poSelfNanoMsg)
   {
      m_poSelfNanoMsg = new NanoMsgClientHandler();
   }
   return m_poSelfNanoMsg;
}


void NanoMsgClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onAvailable()"));
   if (m_poNanoMsgProxy && m_poNanoMsgProxy == proxy)
   {
      m_poNanoMsgProxy->sendSig_EventDigitalInputRegister(*this);
      m_poNanoMsgProxy->sendSig_EventDigitalInputCMPRegister(*this);
      m_poNanoMsgProxy-> sendSig_RspGetDigitalInputCMPRegister(*this);
   }
}


void NanoMsgClientHandler::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onUnavailable()"));
   if (m_poNanoMsgProxy && m_poNanoMsgProxy == proxy)
   {
      m_poNanoMsgProxy->sendSig_EventDigitalInputDeregisterAll();
      m_poNanoMsgProxy->sendSig_EventDigitalInputCMPDeregisterAll();
      m_poNanoMsgProxy->sendSig_RspGetDigitalInputCMPDeregisterAll();
   }
}


void NanoMsgClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("NanoMsgClientHandler register property is called"));
   m_poNanoMsgProxy->sendSig_EventDigitalInputRegister(*this);
}


void NanoMsgClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("NanoMsgClientHandler deregister property is called"));
   m_poNanoMsgProxy->sendSig_EventDigitalInputDeregisterAll();
}


void NanoMsgClientHandler::onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputError "));
}


void NanoMsgClientHandler::onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputResponse "));
}


void NanoMsgClientHandler::onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputError "));
}


void NanoMsgClientHandler::onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputSignal "));
}


/************************************************************************
*FUNCTION		: onSig_EventDigitalInputCMPSignal
*DESCRIPTION	: Error Handling
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: Sig_EventDigitalInputCMPCallbackIF 0x50
************************************************************************/

void NanoMsgClientHandler::onSig_EventDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputCMPError "));
}


//Invoke checkNanoMsgDigPinIsActive  on rvc deactivation  to verify is there any digital pin activated
void NanoMsgClientHandler::checkNanoMsgDigPinIsActive()
{
   if (digitalInputFlag == true)
   {
      ETG_TRACE_USR4(("void NanoMsgClientHandler::checkNanoMsgDigPinIsActive() _digPin_rvcTimer is started "));
      _digPin_rvcTimer.start();
   }
   else
   {
      int activityID = CameraMain::poGetInstance()->vGetActivityID();
      ETG_TRACE_USR4(("void NanoMsgClientHandler::checkNanoMsgDigPinIsActive() NO DIGITIAL PIN Camera on RVC Exit--> activityID==>%d ", activityID));
      if ((activityID == enActivityIDs__eActivityID_CAMERA_STREAM) && (_digPin_rvcTimer.isActive() == false))
      {
         ETG_TRACE_USR4(("void NanoMsgClientHandler::checkNanoMsgDigPinIsActive() NO DIGITIAL PIN Camera on RVC Exit--> sm_gCurrentRegion==>%d ", sm_gCurrentRegion));
         if (sm_gCurrentRegion == REGION_A)
         {
            ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(0, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_STREAM, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
         }
         else if (sm_gCurrentRegion == REGION_C)
         {
            ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(2, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_STREAM, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
         }
         else
         {
            //Do Nothing
         }
      }
   }
}


//Invoke ProcessDigitalPinData on rvc deactivation  or on Digital Pin Trigger
void NanoMsgClientHandler::ProcessDigitalPinData(map<int, int>& RxdRaw_nanoDigPinNdPosMapData)
{
   uint32 digitalInput = 0 ;
   std::string ipaddress = "" ;
   uint16_t position = 0 ;

   int m_camActivationValue = KDSHandler::poGetInstance()->u8GetCameraActivationValue(); // doubt kds has data

   ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData m_camActivationValue , sm_gCMPStatus , sm_gRVCStatus==>%d %d %d ", m_camActivationValue, sm_gCMPStatus, sm_gRVCStatus));
   if ((m_camActivationValue == CAN_NANO_ACTIVE) || (m_camActivationValue == NANO_ACTIVE))
   {
      if ((sm_gCMPStatus == 1) && (sm_gRVCStatus == 0)) // camport is available, and rvc is not active.
      {
         uint8 DigPinvalue = 0;

         /*   NOT_REQ     _myMap[position] = digitalInput;
              NOT_REQ   updateNanoDigPinNdPosMapData(_myMap); */
         // NOT_REQ  verifyNanoMsgDigitalPinAndDisplayRequest();

         std::map<int, int>::iterator itr = RxdRaw_nanoDigPinNdPosMapData.begin();
         for (; itr != RxdRaw_nanoDigPinNdPosMapData.end(); itr++) //O(N)->3 get the position and digitial input for the high digital pin
         {
            ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData position priority "));
            if (itr->second)
            {
               position = itr->first;
               digitalInput = itr->second;
               break;
            }
         }

         ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData  position, digitalInput ==> %d %d ",  position, digitalInput));
         if (itr == RxdRaw_nanoDigPinNdPosMapData.end())// if all d/g input is 0
         {
            ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData No Digital Pin Data activated and Digital Pin Flag is true digitalInputFlag==>%d ", digitalInputFlag));
            if (digitalInputFlag == true) // 1st loop is skiped
            {
               digitalInputFlag = false;
               RequestStopCameraSreamNdConextextSwitchOnDigInput();
            }
            return;
         }

         digitalInputFlag = true;
         //  NOT_REQ uPdateDigitalInputFlagStatus(digitalInputFlag);

         digitalInput = getActualDigitalInputValue(digitalInput); // get the dig input value by passing 32 bit register value
         DigPinvalue = findChannelNoforCamPort(digitalInput); // get the integer value for dig input
         std::string strCamSrc = cameraPortPosSrcName[position][DigPinvalue];     //  --> get the camera source string by comparing to value of array [4x5] position[R] and digital value[C],
         int index = CameraListHandler::getInstance()->bCheckRequestedCamaraExists(strCamSrc);   // In Cockpit Camera List , get the index value from the  camera source string  --> return index, or -1
         ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData last deactivation index, position, digitalInputFlag,digitalInput, DigPinvalue, strCamSrc ==>%d %d %d %d %d %s ", index, position, digitalInputFlag, digitalInput, DigPinvalue, strCamSrc.c_str()));
         if (index == -1)
         {
            POST_MSG((COURIER_MESSAGE_NEW(ActivatePopupNotConfigMsg)()));
            return;
         }

         NanoMsgClientHandler::poGetInstance()->DigPinCamDisplayConditionCheck(index, position, DigPinvalue, strCamSrc);
      }
      else if ((sm_gCMPStatus == 1) && (sm_gRVCStatus == 1))// Digital Pin is received during RVC GEAR IS ACTIVE AND CMG Glass is Active
      {
         ETG_TRACE_USR4(("void NanoMsgClientHandler::ProcessDigitalPinData during Digital Pin is received during RVC GEAR IS ACTIVE AND CMG Glass is Active"));
         //  NOT_REQ RxdRaw_nanoDigPinNdPosMapData[position] = digitalInput;
         // NOT_REQ updateNanoDigPinNdPosMapData(RxdRaw_nanoDigPinNdPosMapData);
         digitalInputFlag = true;
         // NOT_REQ  uPdateDigitalInputFlagStatus(digitalInputFlag);
      }
   }
}


/************************************************************************
*FUNCTION		: onSig_EventDigitalInputCMPSignal
*DESCRIPTION	: Trigger event on pin change
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: Sig_EventDigitalInputCMPCallbackIF 0x50
************************************************************************/
void NanoMsgClientHandler::onSig_EventDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPSignal >& signal)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputCMPSignal Entereed"));
   uint32 digitalInput = signal->getDigitalInputCMP();
   std::string ipaddress = signal->getReceivedIP();
   uint16_t position = getPosition(ipaddress);		// based on ipaddress, fetch the position as per xml.

   // digital pin status info is stored in structure and is used on ignition cycle.
   NanoMsgDigPinItem[position].NanoMsgDigPinsVal = digitalInput;
   NanoMsgDigPinItem[position].NanoMsgPosition = position;
   NanoMsgDigPinItem[position].NanoMsgIpAddress = ipaddress;

   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputCMPSignal  sm_gCMPStatus, sm_gRVCStatus ||| digitalInput,  position,  ipaddress.c_str() : %d %d ||| %d %d %s",  sm_gCMPStatus, sm_gRVCStatus, digitalInput, position, ipaddress.c_str()));
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputCMPSignal Position==>%d||NanoMsgDigPinsVal==>%d || NanoMsgPosition==>%d || NanoMsgIpAddress.c_str()==>%s ", position, NanoMsgDigPinItem[position].NanoMsgDigPinsVal,  NanoMsgDigPinItem[position].NanoMsgPosition, NanoMsgDigPinItem[position].NanoMsgIpAddress.c_str()));
   _myMap[position] = digitalInput;
   updateNanoDigPinNdPosMapData(_myMap);
   ProcessDigitalPinData(_myMap);
}


/************************************************************************
*FUNCTION		: onSig_RspGetDigitalInputCMPError
*DESCRIPTION	: Error Handling
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: Sig_RspGetDigitalInputCMPCallbackIF 0x52
************************************************************************/
void NanoMsgClientHandler::onSig_RspGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputCMPError==> "));
}


/************************************************************************
*FUNCTION		: onSig_RspGetDigitalInputCMPSignal
*DESCRIPTION	: Provide the Digital Pin Data Info on command sendReqGetDigitalInputCMPRequest
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: Sig_RspGetDigitalInputCMPCallbackIF 0x52
************************************************************************/
void NanoMsgClientHandler::onSig_RspGetDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPSignal >& signal)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputCMPSignal_0X52==> "));

   if (m_poNanoMsgProxy && m_poNanoMsgProxy == proxy)
   {
      uint32 digitalInput = signal->getDigitalInputCMP();
      std::string ipaddress = signal->getReceivedIP();
      uint16_t position = getPosition(ipaddress);		// based on ipaddress, fetch the position as per xml.
      ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputCMPSignal_0X52 sm_gCMPStatus, sm_gRVCStatus ||| digitalInput,  position,  ipaddress.c_str(): %d %d ||| %d %d %s",  sm_gCMPStatus, sm_gRVCStatus, digitalInput, position, ipaddress.c_str()));

      NanoMsgDigPinItem[position].NanoMsgDigPinsVal = digitalInput;
      NanoMsgDigPinItem[position].NanoMsgPosition = position;
      NanoMsgDigPinItem[position].NanoMsgIpAddress = ipaddress;

      ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputCMPSignal_0X52 NanoMsgDigPinItem[%d].NanoMsgDigPinsVal==>%d || NanoMsgDigPinItem[%d].NanoMsgPosition==>%d || NanoMsgDigPinItem[%d].NanoMsgIpAddress.c_str()==>%s ", position, NanoMsgDigPinItem[position].NanoMsgDigPinsVal, position, NanoMsgDigPinItem[position].NanoMsgPosition, position, NanoMsgDigPinItem[position].NanoMsgIpAddress.c_str()));

      _myMap[position] = digitalInput;
      updateNanoDigPinNdPosMapData(_myMap);
      ProcessDigitalPinData(_myMap);
   }
}


/************************************************************************
*FUNCTION		: onReqGetDigitalInputCMPError
*DESCRIPTION	: Error Handling
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: ReqGetDigitalInputCMPCallbackIF 0x51
************************************************************************/

void NanoMsgClientHandler::onReqGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputCMPError==> "));
}


/************************************************************************
*FUNCTION		: onReqGetDigitalInputCMPResponse
*DESCRIPTION	: Provide the acknowledgement on command sendReqGetDigitalInputCMPRequest
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*Comment 		: ReqGetDigitalInputCMPCallbackIF 0x51
************************************************************************/
void NanoMsgClientHandler::onReqGetDigitalInputCMPResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPResponse >& response)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputCMPResponse==> "));
}


//Condition Check for the Display of camera on trigger of Digital Pin
void NanoMsgClientHandler::DigPinCamDisplayConditionCheck(uint8 index, uint8 position, uint8 DigPinvalue, std::string strCamSrc)
{
   int _speedStatus = 0;
   uint8 m_isBlackScreenEnabledValue = KDSHandler::poGetInstance()->u8GetCameraBlackScreenFeatureValue();

   bool speedAndParkStatus = VehicleClientHandler::getInstance()->getSpeedAndParkingStatus(); //if return false--> allow camera else Not
   //get the entire vector camtext id (expect -1/FF)image "vector<int> camTextId "
   //(for generic vector is camAvailableXMLTextIdsCockpit)
   vector<int> camTextId = CameraListHandler::getInstance()->getAvailableCameraTextIdOnSelection();
   ETG_TRACE_USR4(("NanoMsgClientHandler::DigPinCamDisplayConditionCheck  ==>m_isBlackScreenEnabledValue ==>index, position, DigPinvalue, camTextId.size(), strCamSrc.c_str()==>%d ==> %d %d %d %d %s", m_isBlackScreenEnabledValue, index, position, DigPinvalue, camTextId.size(), strCamSrc.c_str()));
   if (camTextId.size() != 0)
   {
      CameraConfig::getInstance()-> getSpeedStatus(camTextId.at(index), _speedStatus); // check the speed restriction is applied to corresponding camtext id or not
      bool bSpeedAndParkBrakeStatusValidity = VehicleClientHandler::getInstance()->bGetSpeedAndParkBrakeValidityStatus(); //is brake and speed values are valid or not valid
      ETG_TRACE_USR4(("NanoMsgClientHandler::DigPinCamDisplayConditionCheck bSpeedAndParkBrakeStatusValidity speedAndParkStatus,_speedStatus ==> %d %d %d", bSpeedAndParkBrakeStatusValidity, speedAndParkStatus, _speedStatus));

      //Added validity check for speed and parking brake status. Bug ID 1267971
      if (bSpeedAndParkBrakeStatusValidity == SPEED_AND_PARKBRAKE_STATUS_VALID) //if valid
      {
         if (speedAndParkStatus == ALLOW_CAMERA)   // when speed is 0 and parkbrake is engaged --> no camera restrictions. Allow all cameras.
         {
            ETG_TRACE_COMP(("void NanoMsgClientHandler::DigPinCamDisplayConditionCheck RequestCameraBlackScreen ALLOW_CAMERA"));
            vNanoMsgSelection(index);
         }
         else if (speedAndParkStatus == ALLOW_PARTIAL_OR_BLOCK_CAMERA) 	// restrictions on few cameras. ie, speed is > 0
         {
            if ((_speedStatus == COCKPIT_ONLY) || (_speedStatus == COCKPIT_CABIN))   // check if camera restriction is "NOT "applied to cockpit region or cabin region
            {
               ETG_TRACE_COMP(("void NanoMsgClientHandler::DigPinCamDisplayConditionCheck RequestCameraBlackScreen ALLOW_PARTIAL_OR_BLOCK_CAMERA"));
               vNanoMsgSelection(index);
            }
            else
            {
               POST_MSG((COURIER_MESSAGE_NEW(ActivatePopupMsg)()));
            }
         }
      }
      else
      {
         POST_MSG((COURIER_MESSAGE_NEW(ActivatePopupMsg)()));
      }
   }
}


//Request camera stream and Context switch to cockpit home screen or cabin home screen
void NanoMsgClientHandler::RequestStopCameraSreamNdConextextSwitchOnDigInput()
{
   CameraMain::poGetInstance()->vRequestStopCameraStream();
   ETG_TRACE_USR4(("NanoMsgClientHandler::RequestStopCameraSreamNdConextextSwitchOnDigInput DEACTIVATE_CAM Popup sm_gCurrentRegion==>%d", sm_gCurrentRegion));
   if (sm_gCurrentRegion == REGION_C)
   {
      ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(2, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_SOURCE_SELECTION, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_HOME);
   }
   else if (sm_gCurrentRegion == REGION_A)
   {
      ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(0, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_CABIN_SRCSELECT, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_CABINA_HOME);
   }
   else
   {
      //do nothinf.
   }
}


//Find the Channel Number from Digital Input
uint8 NanoMsgClientHandler::findChannelNoforCamPort(uint32 digitalInput)
{
   uint8 DigPinvalue = 0;
   if (digitalInput == 1)
   {
      DigPinvalue = 1; //indicate 1st pin of camera port position(1/2/3)
   }
   if (digitalInput == 2)
   {
      DigPinvalue = 2;//indicate 2nd pin of camera port position(1/2/3)
   }
   if (digitalInput == 4)
   {
      DigPinvalue = 3;//indicate 3rd pin of camera port position(1/2/3)
   }
   if (digitalInput == 8)
   {
      DigPinvalue = 4;//indicate 4th pin of camera port position(1/2/3)
   }
   ETG_TRACE_USR4(("uint8 NanoMsgClientHandler::findChannelNoforCamPort digitalInput DigPinvalue==>%d %d", digitalInput, DigPinvalue));
   return DigPinvalue;
}


void NanoMsgClientHandler::updateNanoDigPinNdPosMapData(map<int, int>& Rxd_nanoDigPinNdPosMapData)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::updateNanoDigPinNdPosMapData _myMap is UPDATED"));
   _myMap = Rxd_nanoDigPinNdPosMapData;
}


map<int, int> NanoMsgClientHandler:: getNanoDigPinNdPosMapData()
{
   return _myMap;
}


/* void NanoMsgClientHandler::uPdateDigitalInputFlagStatus(bool rxdDigitalInputFlag)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::uPdateDigitalInputFlagStatus rxdDigitalInputFlag==>%d", rxdDigitalInputFlag));
   digitalInputFlag = rxdDigitalInputFlag;
} */


bool NanoMsgClientHandler::getDigitalInputFlagStatus()
{
   return digitalInputFlag;
}


/************************************************************************
*FUNCTION		: onSig_EventDigitalInputSignal
*DESCRIPTION	:
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
]
************************************************************************/
void NanoMsgClientHandler::onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal)
{
   uint32 digitalInput = signal->getDigitalInput();
   bool bStatus = signal->getResponse();
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputSignal DigitalInput :%d , status :%d ", digitalInput, bStatus));
}


void NanoMsgClientHandler::onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error)
{
}


void NanoMsgClientHandler::HandleNanoStatus(int digitalInput, std::string ipaddress)
{
   uint16_t position = getPosition(ipaddress);		// based on ipaddress, fetch the position as per xml.

   ETG_TRACE_USR4(("NanoMsgClientHandler::HandleNanoStatus  sm_gCMPStatus, sm_gRVCStatus ||| digitalInput,  position,  ipaddress.c_str():%d %d ||| %d %d %s",  sm_gCMPStatus, sm_gRVCStatus, digitalInput, position, ipaddress.c_str()));
   map<int, int> _myMap_Simulation;
   _myMap_Simulation[position] = digitalInput;
   updateNanoDigPinNdPosMapData(_myMap_Simulation);

   ProcessDigitalPinData(_myMap_Simulation);
}


int NanoMsgClientHandler::getPosition(std::string ipAddress)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::getPosition() = %s", ipAddress.c_str()));
   int position = 0;
   if (_avRoutingParser != NULL)
   {
      bool m_bParseState = _avRoutingParser->bParseXml();
      position = _avRoutingParser->u16GetCamPos(ipAddress);
   }
   else
   {
      ETG_TRACE_USR4(("NanoMsgClientHandler::getPosition parser pointer null"));
   }
   return position;
}


void NanoMsgClientHandler::vNanoMsgSelection(uint32 digitalInputvalue)
{
   ETG_TRACE_USR4(("void NanoMsgClientHandler::vNanoMsgSelection digitalInputvalue = %d", digitalInputvalue));

   int value = 0;
   std::string strCamSrc = "";
   bool streamStatus = false;
   CameraListHandler::getInstance()->getCameraPositionAndSourceNameValues((digitalInputvalue), value, strCamSrc, streamStatus);

   //Black Screen Loading Animation for few seconds before the Camera is Streamed
   CameraMain::poGetInstance()->sendPluginRequestToAVDECC(PLUGIN_NAME_CAMERA, CVBSSOURCE, value, strCamSrc);

   // _activeCockpitCamera variable value is value is set to indicate active camera in cockpit.
   CameraListHandler::getInstance()->setSelectedCockpitCameraIndex((digitalInputvalue));
   //RVC CRQ -> Check if the first camera is configured for RVC to display warning message.
   if ((strCamSrc == "CMP1_CAM1") && (true == CameraListHandler::getInstance()->bCheckRearCameraAvailable()))
   {
      m_poCameraDataBindingHandler->vShowCameraWarningText(true);
   }
   else
   {
      m_poCameraDataBindingHandler->vShowCameraWarningText(false);
   }
   //Fetch the original xml index based on xml camera source string
   int nanoIndex = CameraListHandler::getInstance()->getOriginalXMLIndex(strCamSrc);
   //CRQ 1366236 Enable Camera Power Management at EvoBus
   CameraListHandler::getInstance()->getCameraPositionAndSourceNameValues(nanoIndex, value, strCamSrc, streamStatus);
   ETG_TRACE_USR3(("void NanoMsgClientHandler::vNanoMsgSelection Cockpit ACTIVATE_CAM COCKPIT :nanoIndex, value,streamStatus,strCamSrc.c_str(), =%d %d %d %s ", nanoIndex, value, streamStatus, strCamSrc.c_str()));
   VehicleClientHandler::getInstance()->vUpdatetoCANfromHMI(strCamSrc, ACTIVATE);//update CAN the active Camera name in the HMI.

   //Request DVC FOR start streaming strCamSrc
   vContextSwitchRequestToCameraScreenViaNanoTrigger();//  Context switch to 258(Black screen of normal camera screen) [or] 251 (directly to normal camera screen)
   CameraMain::poGetInstance()->vRequestStartCameraStream();
   //Update of data binding of the text is taken care in CONTEXTTOMASTER under 251 and 255
   //m_poCameraDataBindingHandler -> updateCameraNameInStreamScreen(CameraListHandler::getInstance()->getActiveCameraName(nanoIndex));
   VehicleClientHandler::getInstance()->SetCANUpdate(true);  // added for Bug Id 1318897
}


// vContextSwitchRequestToCameraScreenViaNanoTrigger--> Context switch to 258(Black screen of normal camera screen) [or] 251 (directly to normal camera screen)
void NanoMsgClientHandler::vContextSwitchRequestToCameraScreenViaNanoTrigger()
{
   uint8 m_isBlackScreenEnabledValue = KDSHandler::poGetInstance()->u8GetCameraBlackScreenFeatureValue();
   ETG_TRACE_USR3(("void NanoMsgClientHandler::vContextSwitchRequestToCameraScreenViaNanoTrigger() m_isBlackScreenEnabledValue==>%d", m_isBlackScreenEnabledValue));
   if (m_isBlackScreenEnabledValue == true) //258(Black screen of normal camera screen)
   {
      ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(2, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0, APPID_APPHMI_CAMERA, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)258);
   }
   else//directly to normal camera screen(No BlackScreen)
   {
      ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(2, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0, APPID_APPHMI_CAMERA, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)251);
   }
}


int NanoMsgClientHandler::getActualDigitalInputValue(uint32 digitalInputvalue)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::getActualDigitalInputValue %d", digitalInputvalue));
   if (digitalInputvalue % 2 == 1)
   {
      digitalInputvalue = 1;
   }
   else if (digitalInputvalue % 4 == 2)
   {
      digitalInputvalue = 2;
   }
   else if (digitalInputvalue == 12)
   {
      digitalInputvalue = 4;
   }
   else if (digitalInputvalue == 8)
   {
      digitalInputvalue = 8;
   }
   ETG_TRACE_USR4(("NanoMsgClientHandler::getActualDigitalInputValue return %d", digitalInputvalue));
   return digitalInputvalue;
}


void NanoMsgClientHandler::onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data)
{
   //If expired, check for the reason and fire SM message
   ETG_TRACE_USR4(("NanoMsgClientHandler::The RVC timer is Expiring"))
   if ((timer.getAct()  == _digPin_rvcTimer.getAct()) && (data->getReason() == asf::core::TimerPayload_Reason__Completed))
   {
      if (digitalInputFlag == true)
      {
         ProcessDigitalPinData(_myMap);
      }

      int activityID = CameraMain::poGetInstance()->vGetActivityID();
      ETG_TRACE_USR4(("VehicleClientHandler::Check activity ID %d", activityID));
      //After RVC disengaged,check for any Digitial Pin is  activated for camera Streaming ,
      //If no camera active, and screen will be in Camera Streaming, then request context switch to home screen.
      //Ex: RVC engaged, Dig PIN activate, Dig Pin deactivate, RVC disengage.
      if ((digitalInputFlag == false) && (activityID == enActivityIDs__eActivityID_CAMERA_STREAM))
      {
         if (sm_gCurrentRegion == REGION_C)
         {
            ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(2, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_SOURCE_SELECTION, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_HOME);
         }
         else if (sm_gCurrentRegion == REGION_A)
         {
            ApplicationSwitchClientComponent::poGetInstance()->requestContextSwitchApplication(0, APPID_APPHMI_CAMERA, enActivityIDs__eActivityID_CAMERA_CABIN_SRCSELECT, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_CABINA_HOME);
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCmd_onCameraNanoStatus, "nanocamStatus %d %s", int, ETG_I_STRING))
void NanoMsgClientHandler::TraceCmd_onCameraNanoStatus(int digitalInput, std::string ipaddress)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::TraceCmd_onCameraNanoStatus"));
   if (m_poSelfNanoMsg != NULL)
   {
      m_poSelfNanoMsg ->HandleNanoStatus(digitalInput, ipaddress);
   }
}


ETG_I_CMD_DEFINE((TraceCmd_onCameraPopupTimerValue, "CameraPopupTimerValue %d ", uint32))
void NanoMsgClientHandler::TraceCmd_onCameraPopupTimerValue(uint32 SetPopupTimerValue)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::TraceCmd_onCameraPopupTimerValue SetPopupTimerValue==>%d", SetPopupTimerValue));
   if (m_poSelfNanoMsg != NULL)
   {
      m_poSelfNanoMsg ->setpopuptimervalue(SetPopupTimerValue);
   }
}


void NanoMsgClientHandler::setpopuptimervalue(uint32 SetPopupTimerValue)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::setpopuptimervalue SetPopupTimerValue==>%d", SetPopupTimerValue));
   popUpTimervalue = SetPopupTimerValue;
}


uint32 NanoMsgClientHandler::getPopupTimerValue()
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::getPopupTimerValue popUpTimervalue==>%d", popUpTimervalue));
   return popUpTimervalue;
}


/************************************************************************
*FUNCTION		: checkDigPinActiveOnSubSystemAvailable
*DESCRIPTION	: on ignition cycle or on startup verifying is any digital pin high
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
]
************************************************************************/
void NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable()
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable==> "));

   uint8 numberOfCMPs = TOTAL_ZERO_CMP;
   if (_avRoutingParser != NULL)
   {
      numberOfCMPs = _avRoutingParser->vectorGetEntityID("CMP").size();
   }
   uint8 camportConnnectedDevice = TOTAL_ZERO_CMP;

   uint8 cmpConnDisconnectStatus  = CameraSourceChangeHandler::getInstance()->getCMPConnectionStatus();
   switch (cmpConnDisconnectStatus)
   {
      case CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_OFF_PRI_ONN:
      case CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_OFF_PRI_ONN:
         camportConnnectedDevice = ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_ONN;
         break;
      case CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_ONN_PRI_ONN:
         camportConnnectedDevice = ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN;
         break;
      case CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_ONN_PRI_ONN:
         camportConnnectedDevice = ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN;
         break;
      default:
         camportConnnectedDevice = ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_OFF;
         break;
   }
   ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable() numberOfCMPs,cmpConnDisconnectStatus,camportConnnectedDevice %d %d %d", numberOfCMPs, cmpConnDisconnectStatus, camportConnnectedDevice));

   for (int i = 0; i <= TOTAL_THREE_CMP; i++)
   {
      ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable() POSITION==>%d||NanoMsgDigPinsVal==>%d || NanoMsgPosition==>%d || NanoMsgIpAddress.c_str()==>%s ", i, NanoMsgDigPinItem[i].NanoMsgDigPinsVal, NanoMsgDigPinItem[i].NanoMsgPosition,  NanoMsgDigPinItem[i].NanoMsgIpAddress.c_str()));
   }

   if (numberOfCMPs >= TOTAL_ONE_CMP)
   {
      if (camportConnnectedDevice == ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_ONN)
      {
         if (NanoMsgDigPinItem[1].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_ONN || DIGITAL 1111"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[1].NanoMsgIpAddress);
         }
         else
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_ONN || DEFAULT ELSE"));
         }
      }
      else if (camportConnnectedDevice == ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN)
      {
         if (NanoMsgDigPinItem[1].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN || DIGITAL 1111"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[1].NanoMsgIpAddress);
         }
         else if (NanoMsgDigPinItem[2].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN || DIGITAL 2222"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[2].NanoMsgIpAddress);
         }
         else
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN || DEFAULT ELSE"));
         }
      }
      else if (camportConnnectedDevice == ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN)
      {
         if (NanoMsgDigPinItem[1].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN || DIGITAL 1111"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[1].NanoMsgIpAddress);
         }
         else if (NanoMsgDigPinItem[2].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN || DIGITAL 2222"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[2].NanoMsgIpAddress);
         }
         else if (NanoMsgDigPinItem[3].NanoMsgDigPinsVal != 0)
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN || DIGITAL 3333"));
            m_poNanoMsgProxy->sendReqGetDigitalInputCMPRequest(*this, 0x05, 0x01, 0x0051, NanoMsgDigPinItem[3].NanoMsgIpAddress);
         }
         else
         {
            ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN || DEFAULT ELSE"));
         }
      }
   }

   ETG_TRACE_USR4(("NanoMsgClientHandler::checkDigPinActiveOnSubSystemAvailable==> EXITEDDDDDD "));
}


}
}
