#include "hall_std_if.h"
#include "KDSHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_CAMERA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Camera_"
#define ETG_I_FILE_PREFIX                 App::Core::KDSHandler::
#include "trcGenProj/Header/KDSHandler.cpp.trc.h"
#endif

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {

KDSHandler* KDSHandler::m_poKDSHandler = NULL;

KDSHandler::KDSHandler()
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR3(("KDSHandler : Constructor"));
   m_u8CabinCameraKDSValue = 0;
   m_variantInfo = 0;

   m_isBlackScreenFeatureEnabled = 0;
   m_cameraBlackScreenTimeOut = 0;

   vReadKDSConfigValues();
   readKDSCameraBlackScreenTimeValue();
   readKDSCameraBlackScreenFeatureValue();
}


KDSHandler::~KDSHandler()
{
   if (m_poKDSHandler != NULL)
   {
      delete m_poKDSHandler;
      m_poKDSHandler = NULL;
   }
   ETG_I_UNREGISTER_FILE();
}


tU8 KDSHandler::getVariantInfoFromKDS()
{
   uint8 variantInfo = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "SystemTypeSelector", &variantInfo, 1))
   {
      ETG_TRACE_USR4(("VariantHandling::variant is ::%d", variantInfo));
      m_variantInfo = variantInfo;
   }

   ETG_TRACE_USR4(("KDSHandler::getVariantInfoFromKDS variant : %d,  isCamportUSBAvailable  %d", variantInfo, m_variantInfo));
   return m_variantInfo;
}


void KDSHandler::vReadKDSConfigValues()
{
   tU8 u8Data, u8DataCamAct, u8DataRvcMsgPosition;
   dp_tclKdsCIS_Configuration oKdsElement;
   oKdsElement.u8GetCameraTileInCabinHomescreen(u8Data);

   oKdsElement.u8GetCameraActivation(u8DataCamAct);
   oKdsElement.u8GetRVCTextPosition(u8DataRvcMsgPosition);
   m_u8CabinCameraKDSValue = u8Data;
   m_u8GetCameraActivation = u8DataCamAct;
   m_u8RvcMsgPositionValue = u8DataRvcMsgPosition;
   ETG_TRACE_USR4(("KDSHandler::vReadKDSConfigValues m_u8CabinCameraKDSValue %d", m_u8CabinCameraKDSValue));
   ETG_TRACE_USR4(("KDSHandler::vReadKDSConfigValues m_u8GetCameraActivation %d", m_u8GetCameraActivation));
   ETG_TRACE_USR4(("KDSHandler::vReadKDSConfigValues m_u8RvcMsgPositionValue %d", m_u8RvcMsgPositionValue));
}


tU16 KDSHandler::u16GetCameraBlackScreenTimeValue()
{
   return m_cameraBlackScreenTimeOut;
}


tU8 KDSHandler::u8GetCameraBlackScreenFeatureValue()
{
   return m_isBlackScreenFeatureEnabled;
}


tU8 KDSHandler::u8GetCabinCameraKDSValue()
{
   return m_u8CabinCameraKDSValue;
}


tU8 KDSHandler::u8GetCameraActivationValue()
{
   return m_u8GetCameraActivation;
}


tU8 KDSHandler::u8GetRvcMsgPositionValue()
{
   return m_u8RvcMsgPositionValue;
}


void KDSHandler::readKDSCameraBlackScreenTimeValue()
{
   uint8 u8CameraBlackScreenTimeValue[2] = {0};
   uint16 u16CameraBlackScreenTimeValue = 0;
   ETG_TRACE_USR1(("KDSHandler::readKDSCameraBlackScreenTimeValue:: "));
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("CIS_Configuration", "CameraBlackScreenTime", &u8CameraBlackScreenTimeValue[0], 2))
   {
      u16CameraBlackScreenTimeValue = static_cast<uint16>((u8CameraBlackScreenTimeValue[0] << 8) | u8CameraBlackScreenTimeValue[1]);
      ETG_TRACE_USR1(("KDSHandler::readKDSCameraBlackScreenTimeValue::%d", u16CameraBlackScreenTimeValue));
      m_cameraBlackScreenTimeOut = u16CameraBlackScreenTimeValue;
   }
}


void KDSHandler::readKDSCameraBlackScreenFeatureValue()
{
   ETG_TRACE_USR1(("KDSHandler::readKDSCameraBlackScreenFeatureValue:: "));
   uint8 isBlackScreenFeatureEnabled = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("CIS_Configuration", "CameraBlackScreenFeature", &isBlackScreenFeatureEnabled, 1))
   {
      ETG_TRACE_USR1(("VariantHandling::readKDSCMPUSBAvailability::%d", isBlackScreenFeatureEnabled));
      m_isBlackScreenFeatureEnabled = isBlackScreenFeatureEnabled;
   }
}


}
}
