/**************************************************************************************
* @file         : CameraSourceChangeHandler.h
* @author       : ECG5- shanmugapriya Murugan
* @addtogroup   :
* @brief        : Class contains necessary business logic required to handle source selection.
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CameraSourceChangeHandler_H
#define CameraSourceChangeHandler_H

#include "AudioSourceChangeProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/HallComponentBase.h"
#include "AppHmi_CameraStateMachine.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "AppHmi_CameraDatabinding.h"
#include "CameraDataBindingHandler.h"
#include "spm_core_fi_typesConst.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "App/Core/NanoMessageClientHandler/NanoMsgClientHandler.h"
#include "CameraListHandler.h"
#include "AVRoutingParser.h"

#define MAPOUT_TRUE 				1
#define MAPOUT_FALSE 				0


#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice
#define HMI_INFO_SERVICE_CHANGE ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService

namespace App {
namespace Core {

using namespace ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
using namespace ::SPM_CORE_FI;
using namespace ::spm_core_fi_types;

class CameraSourceChangeHandler
   : public ::asf::core::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ActivateSourceCallbackIF
   , public ActiveSourceCallbackIF
   , public ActiveSourceListCallbackIF
   , public DeactivateSourceCallbackIF
   , public GetSourceListCallbackIF
   , public SourceListChangedCallbackIF
   , public RegionsMapOutStatusInfoCallbackIF
   , public CabinsSystemsInfoCallbackIF
   , public CabinsSourceRestorationInfoCallbackIF
   , public SetCabinSourceConnectionStatusCallbackIF
   , public CabinsVideoMixInfoCallbackIF
   , public SetCabinVideoMixIndexCallbackIF
{
   public:
      virtual ~CameraSourceChangeHandler();
      static CameraSourceChangeHandler* getInstance();

      bool _spmState;
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);

      void onActivateSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActivateSourceError >& error);
      void onActivateSourceResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActivateSourceResponse >& response);

      void onActiveSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceError >& error);
      void onActiveSourceUpdate(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceUpdate >& update);

      void onActiveSourceListError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceListError >& error);
      void onActiveSourceListUpdate(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceListUpdate >& update);

      void onDeactivateSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< DeactivateSourceError >& error);
      void onDeactivateSourceResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< DeactivateSourceResponse >& response);

      void onGetSourceListError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< GetSourceListError >& error);
      void onGetSourceListResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< GetSourceListResponse >& response);

      void onSourceListChangedError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceListChangedError >& error);
      void onSourceListChangedSignal(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceListChangedSignal >& signal);

      void onRegionsMapOutStatusInfoError(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::RegionsMapOutStatusInfoError >& error);

      void onRegionsMapOutStatusInfoUpdate(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr <HMI_INFO_SERVICE_CHANGE::RegionsMapOutStatusInfoUpdate >& update);

      void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoError >& error);
      void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update);

      void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update);
      void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error);

      void onSetCabinSourceConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SetCabinSourceConnectionStatusError >& error);
      void onSetCabinSourceConnectionStatusResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SetCabinSourceConnectionStatusResponse >& update);
      void onCabinsVideoMixInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsVideoMixInfoError >& error);
      void onCabinsVideoMixInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsVideoMixInfoUpdate >& update);
      void onSetCabinVideoMixIndexError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinVideoMixIndexError >& error);
      void onSetCabinVideoMixIndexResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinVideoMixIndexResponse >& response);
      void requestSourceActivation(_Src SrcID, uint16 sinkId);
      void requestSourceDeActivation(_Src SrcID, uint16 sinkId);
      void requestSourceActDeactOnCabinA2Sink(_Src SrcID, int request);
      bool getSpmHourLogicState();
      void vEvaluateCMP(uint8 systemPosition, uint32 systemStatus, uint32 systemAvdeccStatus, uint32 systemNanoMsgStatus);
      void vEvaluateCMA(uint8 systemPosition, uint32 systemStatus, uint32 systemAvdeccStatus, uint32 systemNanoMsgStatus);
      void vEvaluateCMG(uint8 systemGroup, uint32 systemStatus, uint32 systemAvdeccStatus, uint32 systemNanoMsgStatus);
      void setCMPAvailable(bool flag);
      void setCMAAvailable(bool flag);
      void setCMGAvailable(bool flag);
      bool getCMPStatus();
      bool getCMAStatus();
      bool getCMGStatus();

      void vRequestCameraSourceActivation(int16 srcid);

      CameraDataBindingHandler* m_poCameraDataBindingHandler;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_END()
      bool disconnect_src;
      bool bListRequested;
      void vRequestCameraList();
      uint32 getCameraSourceInCabin();
      void setCameraSourceInCabin(uint32 sourceID, int status);
      uint32 m_cameraSrcID;
      uint32 m_cameraCabinRestoreSrcID;
      std::string _strSplitCamSrcName[3] = {"cockpitSplitView1", "cockpitSplitView2", "cockpitSplitView3"};
      //void vSwitchToHomeScreen();
      void vSwitchToCockpitHomeScreen();
      void vSwitchToCabinHomeScreen();
      bool getPrimaryCMPConnectedStatus();
      bool bPrimaryDetected;
      bool bPrimaryDisconnected;
      int m_cameraSrcConnectionStatus;
      void vCheckIfSourceToBeRestored();

      int m_A1GlassCount, m_A2GlassCount;
      int m_IPCamCount;
      void vA1GlassDisconnectionActions();
      void vA2GlassDisconnectionActions();
      uint32 m_primaryCMPSystemStatus;
      uint32 m_primaryCMPAvdeccSystemStatus;
      uint32 m_primaryCMPNanoMsgStatus;
      uint32 m_secondCMPSystemStatus;
      uint32 m_thirdCMPSystemStatus;
      uint32 m_CMASystemStatus;
      void performSecondCMPActions(uint32 systemStatus, uint32 systemAvdeccStatus, uint32 systemNanoMsgStatus, uint8 systemPosition);
      void performPrimaryCMPActions(uint32 systemStatus, uint32 systemAvdeccStatus, uint32 systemNanoMsgStatus, uint8 systemPosition);
      void sendCabinVideoMixRequest(uint32 region, uint8 reason, uint8 index);
      void vRequestVideoMixRestore(int16 srcid);
      //CRQ 1366236 Handle(Disable) Camera Power Management at EvoBus in the Cabin Region during MAP OUT/CMR VIDEO/USB VIDEO Enable
      void vDeactivateManActForSelectedSourceInCabin();
      void vDeactivateAllCameraManActCabin();
      void vDeactivateSecondaryNdTeritoryCameraManActInCabin();
      void vDeactivateTeritoryCameraManActInCabin();
      bool getCMApnmStatus();
      //Flags to store status of each CMPs

      bool bCMP1Connected;
      bool bCMP2Connected;
      bool bCMP3Connected;

      bool _CMPAvailable = false;
      bool _CMAAvailable = false;
      bool _CMGAvailable = false;
      bool isPnmActivated;
      void fillIPCameraSrc();
      int cmpConnDisconnectStatus;
      struct IPCamConnectionStatus
      {
         uint16_t pos;
         std::string srcNam;
         uint16_t camtextid;;
         bool status;
      };
      vector<IPCamConnectionStatus> stIPCamConnectionStatus = vector<IPCamConnectionStatus>(3);
      void vSendIPCameraSourceStatus();
      void setMappingTextIDforCabinA2();
      int getIPCamCount();
      std::map<int, uint32> cameraNamefromCabinA2;
      uint8 m_prevVideoMixIndex;
      void vSendSrcDeactivationOnPrevMixIndex(uint8 previousIndex, uint8 reason);
      bool bCheckWhetherCameraFromCMP2OrCMP3StreamingInCockpit();
      bool bCheckWhetherCameraFromCMP2OrCMP3StreamingInCabin();
      void vResetListIndexesToDefault();
      void vResetListIndexOnCMP1Disconnection();
      int getA2GlassCount();
      bool currentMic1Status;
      int _variantInfo;

      bool getCurrentMic1Status();
      int getCMPConnectionStatus();
   private :
      CameraSourceChangeHandler();

      act_t _regionsMapOutStatusInfo_RegId;
      ::boost::shared_ptr<AudioSourceChangeProxy > m_audioSourceChangeProxy;
      ::boost::shared_ptr<HmiInfoServiceProxy > _hmiInfoServiceProxy;
};


} // namespace Core
} // namespace App

#endif
