/**************************************************************************************
 * @file         :
 * @author       :
 * @addtogroup   :
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef CAMERADEFINES_H_
#define CAMERADEFINES_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "MediaCameraPort.h"

#define C_DOOR_VIEW         "Door View"
#define C_SURVEILLANCE_VIEW "Surveillance View"
#define C_SURROUND_VIEW     "Surround View"
#define C_REAR_VIEW         "Rear View"
#define C_SPLIT_VIEW        "Split Screen 2:1"
#define C_SPLIT_VIEW_4_1    "Split Screen 4:1"
#define C_SCENIC_VIEW       "Scenic View"

#define DOOR "Door"
#define SURVEILLANCE "Surveillance"
#define SURROUND "Surround"
#define REAR "Rear"
#define SCENIC_CAMERA "Scenic"
#define COCKPITSPLITVIEW "cockpitSplitView"
#define CABINSPLITVIEW "cabinSplitView"
#define LISTID_CAMERA 10
#define MEDIA_STATE_CONNECTING 1
#define MEDIA_STATE_CONNECTED 2

#define MAX_COCKPIT_CAMERA 4         //(CRQ-SplitRemoval)
#define MAX_CABIN_CAMERA 7			//(CRQ-SplitRemoval)

#define CAMERA_RANGE_START 0
#define CAMERA_RANGE_INTER 159
#define CAMERA_RANGE_MAX_VALID 255

#define CMP_NOT_AVAILABLE 0
#define CMP_AVAILABLE 1

#define ZERO_SPEED 0
#define MAX_SPEED 250
#define DEFAULT_SPEED_VALUE_RES 65023
#define DEFAULT_SPEED_VALUE_ERR 65279
#define DEFAULT_SPEED_VALUE_SNA 65535
#define DEFAULT_SPEED_VALUE_SNA_1 25599
#define CAMLIST_STARTUP 100

#define ONE 1
#define TWO 2

#define CAN_NANO_ACTIVE 0
#define NANO_ACTIVE 1
#define CAN_ACTIVE 2
#define REQ_ACTIVATE 	1
#define REQ_DEACTIVATE  2


#define RVC_MSG_X_AXIS_ALL_POSITION 0
#define RVC_MSG_Y_AXIS_TOP_FULL_MODE_POS 5
#define RVC_MSG_Y_AXIS_TOP_NORMAL_MODE_POS 55
#define RVC_MSG_Y_AXIS_BOTTOM_NORMAL_FULL_MODE_POS 365


#define PRIMARY_CMP 1
#define SECOND_CMP 2
#define THIRD_CMP 3

#define TOTAL_ZERO_CMP  0
#define TOTAL_ONE_CMP   1
#define TOTAL_TWO_CMP   2
#define TOTAL_THREE_CMP 3

#define POS_ZERO 	0
#define POS_ONE 	1
#define POS_TWO 	2
#define POS_THREE 	3
#define POS_FOUR 	4
#define POS_FIVE 	5
#define POS_SIX 	6
#define POS_SEVEN 	7

#define CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_OFF_PRI_OFF  		0
#define CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_OFF_PRI_ONN		1
#define CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_ONN_PRI_OFF    	2
#define CAMPORT_CONNECTED_STATUS_TER_OFF_SEC_ONN_PRI_ONN    	3
#define CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_OFF_PRI_OFF		4
#define CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_OFF_PRI_ONN		5
#define CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_ONN_PRI_OFF		6
#define CAMPORT_CONNECTED_STATUS_TER_ONN_SEC_ONN_PRI_ONN		7

#define ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_OFF  	    0
#define ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_OFF_PRI_ONN	    1
#define ACCESSIBLE_CAMPORT_DEVICE_TER_OFF_SEC_ONN_PRI_ONN    	2
#define ACCESSIBLE_CAMPORT_DEVICE_TER_ONN_SEC_ONN_PRI_ONN		3

#define SPEED_AND_PARKBRAKE_STATUS_VALID 1
#define SPEED_AND_PARKBRAKE_STATUS_ERROR 0

#define ALLOW_CAMERA 0   	// The value 0 means that there is no speed restriction. ( No speed Locking )
#define ALLOW_PARTIAL_OR_BLOCK_CAMERA 1   // The value 1 means that there is a speed restrition.   ( Speed Locking )


#define HOURLOGIC_ENABLED  1
#define HOURLOGIC_DISABLED 0
#define PNM_CMA_ENABLED    1
#define PNM_CMA_DISABLED   0

// Camera Activation Source Dig Pin / CAN / Both
#define UNCONFIGURED 00//Both CAN AND DIG PIN // CAN IS Higher prefrence then the DIG PIN
#define DIG_PIN_CAMERA 01
#define CAN_CAMERA 02


#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST


enum enSplitViewType
{
   DEFAULT,
   SPLITVIEW2IN1,
   SPLITVIEW4IN1
};


enum enCamera
{
   INVALID,
   CMP1_CAM1,
   CMP1_CAM2,
   CMP1_CAM3,
   CMP1_CAM4,
   CMP1_IPCAM,
   CMP1_SPLITSCREEN,
   CMP2_CAM1,
   CMP2_CAM2,
   CMP2_CAM3,
   CMP2_CAM4,
   CMP2_SCENICCAM,
   CMP2_SPLITSCREEN,
   CMP3_CAM1,
   CMP3_CAM2,
   CMP3_CAM3,
   CMP3_CAM4,
   CMP3_SCENICCAM,
   CMP3_SPLITSCREEN,
   CMP4_CAM1,
   CMP4_CAM2,
   CMP4_CAM3,
   CMP4_CAM4,
   CMP4_SCENICCAM,
   CMP4_SPLITSCREEN
};


//below enumeration is duplicate. used to resolve build issue. will be deleted after clarification.
//the below defines are used in VehicleClientHandler.h & cpp file.

enum enCameraCAN
{
   CAM1 = 1,
   CAM2,
   CAM3,
   CAM4,
   CAM5,
   CAM6,
   CAM7,
   CAM8,
   CAM9,
   CAM10,
   CAM11,
   CAM12,
   CAM13,
   CAM14,
   CAM15,
   CAM16,
   SCENICCAM1,
   SCENICCAM2,
   SCENICCAM3,
   SCENICCAM4,
   CAMOFF
};


enum enCamportSrc
{
   CAMPORT1_CAM1 = 1,
   CAMPORT1_CAM2,
   CAMPORT1_CAM3,
   CAMPORT1_CAM4
};


// This data is avrouting xml
typedef struct
{
   int position;
   int camTextID;
   std::string camerasource;
   bool streamStatus;
   bool streamStatusCabin;
} stCameraData;

typedef struct
{
   std::string cam;
   _Src camSrc;
} stCamSrcMapping;

typedef struct
{
   enCamera cam;
   enCamportSrc camportSrc;
} stCamportSrcMapping;

typedef struct
{
   std::string camSrcName;
   enCameraCAN cam;
} stCamSrcNameToCANIndex;

typedef struct
{
   uint8 doorCamCount;
   std::vector<std::string> doorCamID;
   uint8 SurvCamCount;
   std::vector<std::string> SurvCamID;
   uint8 SurCamCount;
   std::vector<std::string> SurroundCamID;
   uint8 RearCamCount;
   std::vector<std::string> RearCamID;
   uint8 ScenicCamCount;
   std::vector<std::string> ScenicCamID;
   uint8 SplitViewCount;
   std::vector<std::string> cockpitSplitCamID;
   std::vector<std::string> cabinSplitCamID;
} stCamConfigInfo;

typedef struct
{
   const char* camportName;
   const char* cameraName;
   enCamera cam;
} stCamportConfig;

enum activatedScreen
{
   HOMESCREEN_TILE = 1,
   CAMERA_LIST_SEL,
   NANOMSG_SIGNAL,
   ACTCAM_SIGNAL
};


enum ParkBrakeStatus
{
   PARKING_BRAKE_DISENG = 0,
   PARKING_BRAKE_ENG,
   PARKING_BRAKE_ERR,
   PARKING_BRAKE_SNA
};


enum SystemPosition
{
   EN_POSITION_PRIMARY = 1,
   EN_POSITION_SECONDARY,
   EN_POSITION_TERTIARY
};


enum CAMERA_ACT_DEACT
{
   DEACTIVATE = 0,
   ACTIVATE
};


enum RVC_MSG_HEADER_FOOTER
{
   RVC_MSG_FOOTER = 0,
   RVC_MSG_HEADER
};


enum RVC_MSG_SHOW_HIDE
{
   RVC_MSG_HIDE = 0,
   RVC_MSG_SHOW
};


enum RVC_VIEW_MODE
{
   RVC_FULLMODE = 0,
   RVC_NORMALMODE
};


/* //Camera Port [Camera Port Position][Dig Pin Value]
//Camera Port [CMP][D_PIN]
// D_PIN-0 and CMP_0 is dummy
//		     							  D_PIN-0  D_PIN-1  D_PIN-2  D_PIN-3   D_PIN-3
std::string cameraPortPosSrcName[4][5] = {{"",    ""		,     ""	,    ""	,    ""	   },    //CMP_0
{"", "CMP1_CAM1", "CMP1_CAM2", "CMP1_CAM3", "CMP1_CAM4"}, //CMP_1
{"", "CMP2_CAM1", "CMP2_CAM2", "CMP2_CAM3", "CMP2_CAM4"}, //CMP_2
{"", "CMP3_CAM1", "CMP3_CAM2", "CMP3_CAM3", "CMP3_CAM4"}  //CMP_3
};  */
#endif
//Unit test Compiler switch filter.

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
enum enCamera
{
   INVALID,
   CMP1_CAM1,
   CMP1_CAM2,
   CMP1_CAM3,
   CMP1_CAM4,
   CMP1_IPCAM,
   CMP1_SPLITSCREEN,
   CMP2_CAM1,
   CMP2_CAM2,
   CMP2_CAM3,
   CMP2_CAM4,
   CMP2_SCENICCAM,
   CMP2_SPLITSCREEN,
   CMP3_CAM1,
   CMP3_CAM2,
   CMP3_CAM3,
   CMP3_CAM4,
   CMP3_SCENICCAM,
   CMP3_SPLITSCREEN,
   CMP4_CAM1,
   CMP4_CAM2,
   CMP4_CAM3,
   CMP4_CAM4,
   CMP4_SCENICCAM,
   CMP4_SPLITSCREEN
};


enum enCamportSrc
{
   CAMPORT1_CAM1 = 1,
   CAMPORT1_CAM2,
   CAMPORT1_CAM3,
   CAMPORT1_CAM4
};


typedef struct
{
   enCamera cam;
   enCamportSrc camportSrc;
} stCamportSrcMapping;

#endif

#endif //CAMERADEFINES_H_
