/**************************************************************************************
* @file         : CameraConfig.h
* @author       : ECG5- Shanmugapriya
* @addtogroup   :
* @brief        : Class contains necessary business logic required to read configuration form a file.
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CameraConfig_H
#define CameraConfig_H
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include <fstream>
#include <map>
#include <string>
#include <sstream>
#include "CameraListHandler.h"
#include "CameraDefines.h"
#include "utest/stubs/AudioDefines.h"
#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
struct stCameraNames
{
   //unsigned long long int  PropertyName;
   uint32 PropertyName;
   string UKEnglishTranslation;
   int speedStatus;   // SHOW WHILE DRIVING
   int regionStatus;  // HMI BUTTON AVAILABLE IN REGION
};


enum speedStatus    // SHOW WHILE DRIVING
{
   NONE = 0,        //Not presentable while driving in both regions.
   COCKPIT_ONLY,    //presentable even while driving. applicable in cockpit only
   CABIN_ONLY,      //presentable even while driving. applicable in cabin only
   COCKPIT_CABIN    //presentable both. Applicable in cabin & cockpit only. No restrictions applied.
};


enum regionStatus   // HMI BUTTON AVAILABLE IN REGION
{
   COCKPIT = 1,    //COCKPIT ONLY
   CABIN,          //CABIN ONLY
   BOTH            //COCKPIT AND CABIN
};


class CameraConfig
{
#else
class CameraConfig
{
#endif
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual ~CameraConfig();
      static CameraConfig* getInstance();
      _Src getCabinSrcIdForCam(std::string cameraSelSrc);
      std::string getCabinSrcNameForCamId(int activeCamera);
      inline uint8 getCockpitSrcIdForCam(uint8 value);
      void getCameraValues(int key, uint32& value);
      void setMappingTextID();

      void getSpeedStatus(uint32 key, int& _speedStatus);
      void getRegionStatus(uint32 key, int& _regionStatus);
      int _speedStatus = 0;
      int _regionStatus = 0;

      std::map<int, stCameraNames> cameraNamefromConfig;
      static stCamConfigInfo getCameraConfigStruct();
      int getCANIndexFromCamSrcName(std::string camSrcName);
#else
      int getCockpitSrcIdForCamTest(int value);
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   private:
      CameraConfig();
#endif
};


};


//} // namespace Core
} // namespace App
#endif
