/* ***************************************************************************************
* FILE:          IRenderer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IRenderer.h is part of HMI-Base delivery
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_IRENDERER_H
#define HMIBASE_IRENDERER_H

#include "IHMIAlert_Daemon_Plugin.h"
#include <vector>
#include <string>

namespace hmibase {

namespace alertdaemon {

class IRendererPlugin : public IHMIAlert_Daemon_Plugin
{
   public:
      HMIALERT_PLUGIN_STATIC_HEADER(Renderer)

      /**
       * @brief Returns the identification of a plugin instance.
       *
       * @return The identification of the plugin instance.
       */
      virtual PluginId::Enum GetId() const
      {
         return Id();
      }

      /**
       * @brief Returns the name of a plugin instance.
       *
       * @return Name of the plugin instance.
       */
      virtual const char* GetName() const
      {
         return Name();
      }

      virtual bool update(const std::vector<std::string>& texts) = 0;
};


}
}


#endif
