/* ***************************************************************************************
* FILE:          widget2D_std_if.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  widget2D_std_if is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __widget2d_std_if_
#define __widget2d_std_if_

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdint.h>
#include <sys/types.h>
#include <vector>
#include <string>
#include <map>

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#define NOGDICAPMASKS
//#define NOVIRTUALKEYCODES
#define NOWINMESSAGES
#define NOWINSTYLES
#define NOSYSMETRICS
#define NOMENUS
#define NOICONS
#define NOKEYSTATES
#define NOSYSCOMMANDS
#define NORASTEROPS
#define NOSHOWWINDOW
#define OEMRESOURCE
#define NOATOM
#define NOCLIPBOARD
#define NOCOLOR
#define NOCTLMGR
#define NODRAWTEXT
#define NOGDI
#define NOKERNEL
//#define NOUSER
#define NONLS
#define NOMB
#define NOMEMMGR
#define NOMETAFILE
#ifndef NOMINMAX
#define NOMINMAX
#endif
#define NOMSG
#define NOOPENFILE
#define NOSCROLL
#define NOSERVICE
#define NOSOUND
#define NOTEXTMETRIC
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI
#define NOHELP
#define NOPROFILER
#define NODEFERWINDOWPOS
#define NOMCX
#endif

#include "FeatStd/Base.h"
#include "Courier/Version.h"
#include "Courier/Base.h"
#include "hmibase/util/StringUtils.h"
#include "AppUtils/HmiMacros.h"
#include "hmi_trace_if.h"
#include "Widgets/widget_etg_if.h"
#include "lint_deactivation.h"

#include <Candera/System/Mathematics/Vector2.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayProperty.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include <CanderaWidget/String/String.h>
#include <Courier/Platform/AtomicOp.h>
#include <Courier/DataBinding/DataBindingMsg.h>
#include <Courier/Visualization/VisualizationMsgs.h>

#else
#error "Please include widget2d_std_if.h allways first and once a time in your Widget cpp file, but never in a header file!"
#endif
