/* ***************************************************************************************
* FILE:          Widgets.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Widgets.h is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

//allow multiple includes for this file

//these defines are here only for debug purpose
//#define HMIBASE_INCLUDE_WIDGET_ALL
//#define HMIBASE_INCLUDE_WIDGET_2D_ALL
//#define HMIBASE_INCLUDE_WIDGET_3D_ALL


///////////////////////////////////////////////////////////////////////////////
// common
///////////////////////////////////////////////////////////////////////////////
#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_DEFAULTS)
#include <View/CGI/CgiExtensions/CanderaDefaults.h>
#include <Widgets/utils/WidgetDefaults.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_UTIL)
#include <Widgets/utils/WidgetDefaults.h>
#include <Widgets/utils/WidgetFunctors.h>
#include <Widgets/utils/WidgetTraverser.h>
#include <Widgets/2D/WidgetGestureConfig.h>
#include <Widgets/2D/WidgetFinder2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_CONTROLLER)
#include <View/CGI/Widget/WidgetController.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_DATA_MODEL)
#include <Widgets/DataModel/WidgetDataModel.h>
#endif

///////////////////////////////////////////////////////////////////////////////
// 2D
///////////////////////////////////////////////////////////////////////////////
#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BASE)
#include <Widgets/2D/BaseWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TOUCHABLE)
#include <Widgets/2D/Touchable2D.h>
#endif


#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ADORNER)
#include <Widgets/2D/Adorner/Adorner.h>
#include <Widgets/2D/Adorner/DefaultAdorner.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ANGULAR_SLIDER)
#include <Widgets/2D/Slider/AngularSliderWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ANIMATION)
#include <Widgets/2D/Animation/AnimationWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_APPEARANCE)
#include <Widgets/2D/Appearance/Appearance2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BASELINE_LAYOUTER)
#include <Widgets/2D/BaseLineLayouter/BaseLineLayouterWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BLUR)
#include <Widgets/2D/Blur/BlurViewScene2D.h>
#include <Widgets/2D/Blur/BlurWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUSY_INDICATOR)
#include <Widgets/2D/BusyIndicator/BusyIndicatorWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON)
#include <Widgets/2D/Button/ButtonTouchHandler.h>
#include <Widgets/2D/Button/ButtonWidget2D.h>
#include <Widgets/2D/Button/ButtonAppearance2D.h>
#include <Widgets/2D/Button/ButtonAnimatedReleaseController2D.h>
#include <Widgets/2D/Button/ButtonBubbleController2D.h>
#include <Widgets/2D/Button/ButtonSlideController2D.h>
#include <Widgets/2D/Button/ToggleButton2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON_ANIMATION)
#include <Widgets/2D/ButtonAnimation/ButtonAnimationWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON_GROUP)
#include <Widgets/2D/ButtonGroup/ButtonGroupWidget2D.h>
#include <Widgets/2D/ButtonGroup/ButtonGroupController2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON_IMAGE)
#include <Widgets/2D/ButtonImage/ButtonImageWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON_TEXT_COLOR)
#include <Widgets/2D/ButtonText/ButtonTextColorWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_BUTTON_TEXT_SCROLL)
#include <Widgets/2D/ButtonText/ButtonTextScrollWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_CANVAS_LAYOUTER)
#include <Widgets/2D/CanvasLayouter/CanvasLayouterWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_CLOCK)
#include <Widgets/2D/Clock/ClockWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_COLLAPSE)
#include <Widgets/2D/Collapse/CollapseWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_COLOR_BAR)
#include <Widgets/2D/ColorBar/ColorBarWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_COLOR_EFFECT)
#include <Widgets/2D/EffectControl/ColorEffectWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_COVERFLOW_LIST)
#include <Widgets/2D/List/CoverflowListWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DELEGATE)
#include <Widgets/2D/Delegate/DelegateWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DIRECT_TEXTURE_CONSUMER)
#include <Widgets/2D/DirectTextureConsumer/DirectTextureConsumer2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DIRECT_TEXTURE_PROVIDER)
#include <Widgets/2D/DirectTextureProvider/DirectTextureProvider2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DOCK_SIDE)
#include <Widgets/2D/DockSide/DockSideWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DRAG_DROP)
#include <Widgets/2D/DragDrop/DDAdorner.h>
#include <Widgets/2D/DragDrop/DDManager.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DRAG_DROP) || defined(HMIBASE_INCLUDE_WIDGET_2D_DRAG_DROP_MODEL)
#include <Widgets/2D/DragDrop/DDModelBase.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_DROP_DOWN_LIST)
#include <Widgets/2D/DropDownList/DropDownListWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_EDIT_FIELD)
#include <Widgets/2D/EditField/EditFieldWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_FOCUS)
#include <Widgets/2D/Focus/FocusGroupWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_GESTURE)
#include <Widgets/2D/Gesture/GestureWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_GIZMO)
#include <Widgets/2D/Gizmo/GizmoController2D.h>
#include <Widgets/2D/Gizmo/GizmoWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_GRID_AUTO_ARRANGE)
#include <Widgets/2D/GridAutoArrange/GridAutoArrangeWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_IMAGE_EFFECT)
#include <Widgets/2D/ImageEffect/ImageEffectWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_IMAGE_SWITCH)
#include <Widgets/2D/ImageSwitch/ImageSwitchWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_LABEL)
#include <Widgets/2D/Label/LabelWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_LIST)
#include <Widgets/2D/List/ListController2D.h>
#include <Widgets/2D/List/ListWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_LIST_BINDING)
#include <Widgets/2D/TempWidgets2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_LIST_ITEM_ANIMATION)
#include <Widgets/2D/ListItemAnimationMarker/ListItemAnimationMarkerWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_LIST_DATA)
#include <Widgets/2D/List/Data/ListDataProviderBuilder.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_MARGIN)
#include <Widgets/2D/Layout/MarginWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_MARKER)
#include <Widgets/2D/Marker/MarkerWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_METER)
#include <Widgets/2D/MeterWidget/MeterWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_MULTI_SLIDER)
#include <Widgets/2D/MultiSlider/MultiSliderWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_NODE_CONTROL)
#include <Widgets/2D/NodeControl/NodeControlWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_OPS)
#include <Widgets/2D/OPS/OPSWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_OVERLAY_LAYOUTER)
#include <Widgets/2D/OverlayLayouter/OverlayLayouterWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_PAGE_EDIT)
#include <Widgets/2D/PageEdit/PageEditController2D.h>
#include <Widgets/2D/PageEdit/PageEditWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_PANEL_SLIDE)
#include <Widgets/2D/PanelSlide/PanelSlideWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_PROGRESS_BAR)
#include <Widgets/2D/ProgressBar/ProgressBarWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SCOPE)
#include <Widgets/2D/Scope/ScopeWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SCROLABLE_TEXT)
#include <Widgets/2D/ScrollableText/ScrollableTextWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SCROLLBAR)
#include <Widgets/2D/ScrollBar/ScrollBarWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SIZE)
#include <Widgets/2D/Size/SizeWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SLIDER)
#include <Widgets/2D/Slider/SliderWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SOLID_COLOR_EFFECT)
#include <Widgets/2D/SolidColorEffect/SolidColorEffectWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SPELLER)
#include <Widgets/2D/Speller/SpellerButtonController2D.h>
#include <Widgets/2D/Speller/SpellerWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_STEP_ANIMATION)
#include <Widgets/2D/StepAnimation/StepAnimationWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SURFACE_INPUT_REGION)
#include <Widgets/2D/SurfaceInputRegion/SurfaceInputRegionWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_SWITCH)
#include <Widgets/2D/Switch/SwitchWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT)
#include <Widgets/2D/Text/TextWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_STYLE_CONFIGURATOR)
#include <Widgets/2D/Text/TextStyleConfigurator.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_AREA)
#include <Widgets/2D/TextArea/TextAreaWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_BASELINE_OFFSET)
#include <Widgets/2D/TextBaseLineOffset/TextBaseLineOffsetWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_COLOR)
#include <Widgets/2D/TextColor/TextColorWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_EXTENSION)
#include <Widgets/2D/TextExtension/TextExtensionWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TEXT_WAIT_ANIMATION)
#include <Widgets/2D/TextWaitAnimation/TextWaitAnimationWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TIMER)
#include <Widgets/2D/TimerWidget/TimerWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TOGGLE)
#include <Widgets/2D/Toggle/ToggleWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_TWO_DIMENSION_SLIDER)
#include <Widgets/2D/TwoDimensionSlider/TwoDimensionSliderWidget2D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_2D_VIEW_SWITCH)
#include <Widgets/2D/ViewSwitch/ViewSwitchWidget2D.h>
#endif


///////////////////////////////////////////////////////////////////////////////
// 3D
///////////////////////////////////////////////////////////////////////////////
#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_BASE)
#include <Widgets/3D/BaseWidget3D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_TOUCHABLE)
#include <Widgets/3D/Touchable3D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_BLUR)
#include <Widgets/3D/Blur/BlurViewScene3D.h>
#include <Widgets/3D/Blur/BlurWidget3D.h>
#endif

//#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_DIRECT_TEXTURE_CONSUMER)
//#include <Widgets/3D/DirectTexture/DirectTextureConsumer3D.h>
//#endif

//#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_DIRECT_TEXTURE_PROVIDER)
//#include <Widgets/3D/DirectTexture/DirectTextureProvider3D.h>
//#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_LINE_LIST)
#include <Widgets/3D/LineList/LineListWidget3D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_MULTI_SLIDER_HELPER)
#include <Widgets/3D/MultiSliderHelper/MultiSliderHelperWidget3D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_SIMPLE_BUTTON)
#include <Widgets/3D/Button/SimpleButtonWidget3D.h>
#endif

#if defined(HMIBASE_INCLUDE_WIDGET_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_ALL) || defined(HMIBASE_INCLUDE_WIDGET_3D_TEXTURE_IMAGE)
#include <Widgets/3D/TextureImage/TextureImageWidget3D.h>
#endif
