/* ***************************************************************************************
* FILE:          widget_etg_if.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  widget_etg_if is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __WIDGET_ETG_IF_H
#define __WIDGET_ETG_IF_H

/*
;;  widget trace class definition for HMI - Base G3G projects(base 0x2840)
;;  this trace classes with base 0x2840 defined for HMI - Base project and should work
;;
;;	This trace classes works only in DCL mode, means for example to see all
;;  SliderWidget2D traces you have to enable
;;    1) Generic Application widget trace with e.g TR_CLASS_APPHMI_DEMOWIDGETS_WIDGET
;;    2) Framework widget trace class, in this case TR_CLASS_HMI_WIDGET_SLIDER
;;
;; TR_CLASS_HMI_WIDGET_BASE(TR_COMP_UI + 64)                       ; 0x2800 HMI_Framework or old monolithic HMI application
;;                                                                 ; reserved from 64..112 = 48 Widgets
;; TR_CLASS_HMI_WIDGET_ANIMATION(TR_CLASS_HMI_WIDGET_BASE + 1)		 ; see also ..\ai_hmi_base\components\WidgetRepository\Widgets\widget_etg_if.trc
;; TR_CLASS_HMI_WIDGET_BUTTON(TR_CLASS_HMI_WIDGET_BASE + 2)
;;
;; TR_COMP_UI + 64 -> 0x2840
;
*/

// justified based on historical issues( max = 48 classes )
#define TR_CLASS_HMI_WIDGET_ANIMATION           (TR_CLASS_HMI_WIDGET_BASE +1)       // 0x2841
#define TR_CLASS_HMI_WIDGET_BUTTON              (TR_CLASS_HMI_WIDGET_BASE +2)       // 0x2842
#define TR_CLASS_HMI_WIDGET_BASEWIDGET          (TR_CLASS_HMI_WIDGET_BASE +3)
#define TR_CLASS_HMI_WIDGET_CLOCK               (TR_CLASS_HMI_WIDGET_BASE +4)
#define TR_CLASS_HMI_WIDGET_EDITFIELD           (TR_CLASS_HMI_WIDGET_BASE +5)       // 0x2845
#define TR_CLASS_HMI_WIDGET_IMAGE               (TR_CLASS_HMI_WIDGET_BASE +6)       // 0x2846
#define TR_CLASS_HMI_WIDGET_HANDWRITING         (TR_CLASS_HMI_WIDGET_BASE +7)       // 0x2847
#define TR_CLASS_HMI_WIDGET_HELPERWIDGETS       (TR_CLASS_HMI_WIDGET_BASE +8)       // 0x2848
#define TR_CLASS_HMI_WIDGET_DIRECTTEXTURE       (TR_CLASS_HMI_WIDGET_BASE +9)
#define TR_CLASS_HMI_WIDGET_ADORNER             (TR_CLASS_HMI_WIDGET_BASE +10)
#define TR_CLASS_HMI_WIDGET_OPS                 (TR_CLASS_HMI_WIDGET_BASE +11)
#define TR_CLASS_HMI_WIDGET_SLIDER              (TR_CLASS_HMI_WIDGET_BASE +12)      // 0x284C
#define TR_CLASS_HMI_WIDGET_SPELLER             (TR_CLASS_HMI_WIDGET_BASE +13)      // 0x284D
#define TR_CLASS_HMI_WIDGET_TEXT                (TR_CLASS_HMI_WIDGET_BASE +14)      // 0x284E
#define TR_CLASS_HMI_WIDGET_GRAPHWIDGETS        (TR_CLASS_HMI_WIDGET_BASE +15)      // 0x284F
#define TR_CLASS_HMI_WIDGET_TIMER               (TR_CLASS_HMI_WIDGET_BASE +16)
#define TR_CLASS_HMI_WIDGET_FOCUS               (TR_CLASS_HMI_WIDGET_BASE +17)
#define TR_CLASS_HMI_WIDGET_LIST                (TR_CLASS_HMI_WIDGET_BASE +18)      // 0x2852
#define TR_CLASS_HMI_WIDGET_PROGRESSBAR         (TR_CLASS_HMI_WIDGET_BASE +19)
#define TR_CLASS_HMI_WIDGET_SCROLLBAR           (TR_CLASS_HMI_WIDGET_BASE +20)
#define TR_CLASS_HMI_WIDGET_GLOW                (TR_CLASS_HMI_WIDGET_BASE +21)
#define TR_CLASS_HMI_WIDGET_LAYOUTER            (TR_CLASS_HMI_WIDGET_BASE +22)
#define TR_CLASS_HMI_WIDGET_METER               (TR_CLASS_HMI_WIDGET_BASE +23)
#define TR_CLASS_HMI_WIDGET_NODECONTROL         (TR_CLASS_HMI_WIDGET_BASE +24)
#define TR_CLASS_HMI_WIDGET_SWITCH              (TR_CLASS_HMI_WIDGET_BASE +25)
#define TR_CLASS_HMI_WIDGET_WAITANIMATION       (TR_CLASS_HMI_WIDGET_BASE +26)
#define TR_CLASS_HMI_WIDGET_EFFECTCONTROL       (TR_CLASS_HMI_WIDGET_BASE +27)
#define TR_CLASS_HMI_WIDGET_TOUCHABLE           (TR_CLASS_HMI_WIDGET_BASE +28)
#define TR_CLASS_HMI_WIDGET_LAYOUTING           (TR_CLASS_HMI_WIDGET_BASE +29)      // 0x285D

#define TR_CLASS_HMI_WIDGET_BLUR                (TR_CLASS_HMI_WIDGET_BASE +30)
#define TR_CLASS_HMI_WIDGET_APPEARANCE          (TR_CLASS_HMI_WIDGET_BASE +31)
#define TR_CLASS_HMI_WIDGET_GESTURE             (TR_CLASS_HMI_WIDGET_BASE +32)
#define TR_CLASS_HMI_WIDGET_GIZMO               (TR_CLASS_HMI_WIDGET_BASE +33)
#define TR_CLASS_HMI_WIDGET_RICHTEXT            (TR_CLASS_HMI_WIDGET_BASE +34)
#define TR_CLASS_HMI_WIDGET_PAGEEDIT            (TR_CLASS_HMI_WIDGET_BASE +35)
#define TR_CLASS_HMI_WIDGET_BUTTONANIMATION     (TR_CLASS_HMI_WIDGET_BASE +36)
#define TR_CLASS_HMI_WIDGET_MESH                (TR_CLASS_HMI_WIDGET_BASE +37)
#define TR_CLASS_HMI_WIDGET_COMBOBOX            (TR_CLASS_HMI_WIDGET_BASE +38)
#define TR_CLASS_HMI_WIDGET_XReserved39         (TR_CLASS_HMI_WIDGET_BASE +39)
#define TR_CLASS_HMI_WIDGET_XReserved40         (TR_CLASS_HMI_WIDGET_BASE +40)
#define TR_CLASS_HMI_WIDGET_XReserved41         (TR_CLASS_HMI_WIDGET_BASE +41)
#define TR_CLASS_HMI_WIDGET_XReserved42         (TR_CLASS_HMI_WIDGET_BASE +42)
#define TR_CLASS_HMI_WIDGET_XReserved43         (TR_CLASS_HMI_WIDGET_BASE +43)
#define TR_CLASS_HMI_WIDGET_XReserved44         (TR_CLASS_HMI_WIDGET_BASE +44)
#define TR_CLASS_HMI_WIDGET_XReserved45         (TR_CLASS_HMI_WIDGET_BASE +45)
#define TR_CLASS_HMI_WIDGET_XReserved46         (TR_CLASS_HMI_WIDGET_BASE +46)
#define TR_CLASS_HMI_WIDGET_XReserved47         (TR_CLASS_HMI_WIDGET_BASE +47)
#define TR_CLASS_HMI_WIDGET_last_possible       (TR_CLASS_HMI_WIDGET_BASE +48)


#endif
