/* ***************************************************************************************
* FILE:          WidgetTraverser.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetTraverser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(WidgetTraverser_h)
#define WidgetTraverser_h

#include <Candera/EngineBase/Common/TreeTraverserBase.h>

namespace Courier {
class Message;
}


namespace Candera {
class CompositeGroup2D;
class Widget2D;
class Scene2DContext;
}


namespace hmibase {
namespace widget {
namespace utils {

class MessageUtils
{
   public:
      static Candera::Scene2DContext* getSceneContext(Candera::Widget2D* widget);
      static const Candera::CompositeGroup2D* getCompositeNode(const Candera::Node2D* node);
      static bool distribute(Candera::Scene2DContext* sceneContext, const Courier::Message& msg);
      static bool distributeToAncestors(Candera::Scene2DContext* sceneContext, const Candera::Node2D& startNode, const Courier::Message& msg);
      static bool distributeToDescendants(Candera::Scene2DContext* sceneContext, const Candera::Node2D& startNode, const Courier::Message& msg);
      static bool distributeToControlTemplate(const Candera::Node2D& node, const Courier::Message& msg);
      static bool distributeToControlTemplate(const Candera::Node&, const Courier::Message&)
      {
         return false;
      }
};


template <typename TNode, typename TCompositeGroup>
class SceneNodeMessageDistributor : public Candera::TreeTraverserBase<TNode>
{
      typedef Candera::TreeTraverserBase<TNode> Base;

   public:
      SceneNodeMessageDistributor(const Courier::Message& msg, bool distributeToControlTemplate)
         : _msg(msg), _distributeToControlTemplate(distributeToControlTemplate), _consumed(false)
      {
      }

      bool isConsumed() const
      {
         return _consumed;
      }

   protected:
      typename Base::TraverserAction ProcessNode(TNode& node)
      {
         if (_consumed)
         {
            return Base::StopTraversing;
         }

         TCompositeGroup* compositeGroup = Candera::Dynamic_Cast<TCompositeGroup*>(&node);
         if (compositeGroup != NULL)
         {
            for (typename TCompositeGroup::WidgetIterator it = compositeGroup->GetWidgetIterator(); it.IsValid(); ++it)
            {
               _consumed = (*it)->OnMessage(_msg);
               if (_consumed)
               {
                  return Base::StopTraversing;
               }
            }
         }

         if (_distributeToControlTemplate)
         {
            //this is required because widgets cloned by the list are not added to their composite group, instead they are kept into the control template data of the node
            _consumed = MessageUtils::distributeToControlTemplate(node, _msg);
            if (_consumed)
            {
               return Base::StopTraversing;
            }
         }

         return Base::ProceedTraversing;
      }

   private:
      SceneNodeMessageDistributor(const SceneNodeMessageDistributor&);
      SceneNodeMessageDistributor& operator=(const SceneNodeMessageDistributor&);

      const Courier::Message& _msg;
      bool _distributeToControlTemplate;
      bool _consumed;
};


}
}


}
#endif//WidgetTraverser_h
