/* ***************************************************************************************
* FILE:          WidgetDefaults.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetDefaults.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "WidgetDefaults.h"

#include <hmi_trace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BASEWIDGET
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/WidgetDefaults.cpp.trc.h"
#endif

#ifdef WIN32
#include <windows.h>
#include <hmibase/util/EnumInfo.h>
#endif

namespace hmibase {
namespace widget {

WidgetDefaults::TextDirectionType WidgetDefaults::_textDirection = ::hmibase::widget::text::enDirection::Legacy;
bool WidgetDefaults::_textCultureDependentAlignment = true;

void WidgetDefaults::SetTextDirection(TextDirectionType textDirection)
{
   _textDirection = textDirection;
}


void WidgetDefaults::SetTextCultureDependentAlignment(bool textCultureDependentAlignment)
{
   _textCultureDependentAlignment = textCultureDependentAlignment;
}


#ifdef WIN32

#define HMIBASE_DEFAULTS_SET_VALUE(propName, propValueString){\
propName##Type propValue;\
if (HMIBASE_ENUM_INFO_CONVERT_STRING(propName##Type, propValueString, propValue)){\
   Set##propName(propValue);\
}}


bool WidgetDefaults::InitSCHost()
{
   const char* textDefaultDirection = getenv("HMIBASE_WIDGET_TEXT_DEFAULT_DIRECTION");
   if (textDefaultDirection != NULL)
   {
      HMIBASE_DEFAULTS_SET_VALUE(TextDirection, textDefaultDirection)
   }
   const char* textDefaultCultureDependentAlignment = getenv("HMIBASE_WIDGET_TEXT_DEFAULT_CULTURE_DEPENDENT_ALIGNMENT");
   if (textDefaultCultureDependentAlignment != NULL)
   {
      SetTextCultureDependentAlignment((strcmp(textDefaultCultureDependentAlignment, "true") == 0) || (strcmp(textDefaultCultureDependentAlignment, "1") == 0));
   }
   return true;
}


#endif
}


}
