/* ***************************************************************************************
 * FILE:          ColorPropertyAccessor.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ColorPropertyAccessor is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#if !defined(hmibase_ColorPropertyAccessor_h)
#define hmibase_ColorPropertyAccessor_h

#include <Widgets/2D/ColorSwitch/generated/ColorSwitchWidget2DTypes.h>

namespace Candera {
class Color;
class Node2D;
class Widget2D;
}


namespace hmibase {
namespace widget {
namespace color {


/*****************************************************************************/
class ColorPropertyAccessor
{
   public:
      virtual ~ColorPropertyAccessor() {}

      virtual void Set(const Candera::Color& color) = 0;
      virtual Candera::Color Get() const = 0;
};


/*****************************************************************************/
template <typename TTarget>
class ColorPropertyAccessorBase : public ColorPropertyAccessor
{
   public:
      ColorPropertyAccessorBase(TTarget* target, int propertyHint = 0) : _target(target), _propertyHint(propertyHint)
      {
      }

      static void Set(TTarget& target, const Candera::Color& color, int propertyHint);

      virtual void Set(const Candera::Color& color) override
      {
         if (_target != NULL)
         {
            Set(*_target, color, _propertyHint);
         }
      }

      static Candera::Color Get(TTarget& target, int propertyHint);

      virtual Candera::Color Get() const override
      {
         return _target != NULL ? Get(*_target, _propertyHint) : Candera::Color();
      }

   protected:
      TTarget* _target;
      int _propertyHint;
};


/*****************************************************************************/
class ColorPropertyHelper
{
   public:
      static ColorPropertyAccessor* Create(Candera::Widget2D& widget, Candera::Node2D& node, int propertyHint);

   private:
      ColorPropertyHelper();
};


}
}


}


#endif // hmibase_ColorPropertyAccessor_h
