/* ***************************************************************************************
 * FILE:          ColorPropertyAccessor.cpp
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ColorPropertyAccessor is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#include "widget2D_std_if.h"
#include "ColorPropertyAccessor.h"

#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>
#include <Widgets/2D/ControlTemplate/TTraverserBase.h>
#include <Widgets/2D/EffectControl/ColorEffectWidget2D.h>

#include <Widgets/2D/WidgetFinder2D.h>
#include <Widgets/utils/EffectUtils.h>
#include <Widgets/2D/RichText/RichTextWidget2D.h>
#include <Widgets/2D/RichText/RichTextHighlightWidget2D.h>
#include <Widgets/2D/TextArea/TextAreaWidget2D.h>
#include <Widgets/2D/Text/TextWidget2D.h>

#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_APPEARANCE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ColorPropertyAccessor.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace color {


/*****************************************************************************/
template<>
void ColorPropertyAccessorBase<Candera::ColorProperty>::Set(Candera::ColorProperty& target, const Candera::Color& color, int propertyId)
{
   (void)propertyId;
   target.Set(color.GetData());
}


/*****************************************************************************/
template<>
Candera::Color ColorPropertyAccessorBase<Candera::ColorProperty>::Get(Candera::ColorProperty& target, int propertyId)
{
   (void)propertyId;
   return Candera::Color(target.Get());
}


using namespace hmibase::widget::richtext;
/*****************************************************************************/
template<>
void ColorPropertyAccessorBase<RichTextWidget2D>::Set(RichTextWidget2D& target, const Candera::Color& color, int propertyId)
{
   (void)propertyId;
   target.SetColor(color);
}


/*****************************************************************************/
template<>
Candera::Color ColorPropertyAccessorBase<RichTextWidget2D>::Get(RichTextWidget2D& target, int propertyId)
{
   (void)propertyId;
   return target.GetColor();
}


/*****************************************************************************/
template<>
void ColorPropertyAccessorBase<RichTextHighlightWidget2D>::Set(RichTextHighlightWidget2D& target, const Candera::Color& color, int propertyId)
{
   if (propertyId == enColorProperty::Widget_RichTextHighlightBgColor)
   {
      target.SetBackgroundColor(color);
   }
   else
   {
      target.SetTextColor(color);
   }
}


/*****************************************************************************/
template<>
Candera::Color ColorPropertyAccessorBase<RichTextHighlightWidget2D>::Get(RichTextHighlightWidget2D& target, int propertyId)
{
   if (propertyId == enColorProperty::Widget_RichTextHighlightBgColor)
   {
      return target.GetBackgroundColor();
   }
   else
   {
      return target.GetTextColor();
   }
}


/*****************************************************************************/
template<>
void ColorPropertyAccessorBase<TextAreaWidget2D>::Set(TextAreaWidget2D& target, const Candera::Color& color, int propertyId)
{
   if (propertyId == enColorProperty::Widget_TextAreaHighlightColor)
   {
      target.SetHighlightTextColor(color);
   }
   else
   {
      target.SetNormalTextColor(color);
   }
}


/*****************************************************************************/
template<>
Candera::Color ColorPropertyAccessorBase<TextAreaWidget2D>::Get(TextAreaWidget2D& target, int propertyId)
{
   if (propertyId == enColorProperty::Widget_TextAreaHighlightColor)
   {
      return target.GetHighlightTextColor();
   }
   else
   {
      return target.GetNormalTextColor();
   }
}


/*****************************************************************************/
template<>
void ColorPropertyAccessorBase<TextWidget2D>::Set(TextWidget2D& target, const Candera::Color& color, int propertyId)
{
   (void)propertyId;
   target.SetTextColor(color);
}


/*****************************************************************************/
template<>
Candera::Color ColorPropertyAccessorBase<TextWidget2D>::Get(TextWidget2D& target, int propertyId)
{
   (void)propertyId;
   return target.GetTextColor();
}


/*****************************************************************************/
#define __EFFECT_COLOR_PROPERTY_CASE(pPropId, pPropHint) \
      case enColorProperty::pPropId: \
      { \
         Candera::ColorProperty* colorProperty = hmibase::widget::utils::EffectUtils::getColorProperty(&node, hmibase::widget::utils::EffectUtils::colorid::pPropHint); \
         if (colorProperty != NULL) \
         { \
            colorPropertyAccessor = FEATSTD_NEW(ColorPropertyAccessorBase<Candera::ColorProperty>)(colorProperty, hmibase::widget::utils::EffectUtils::colorid::pPropHint); \
         } \
         break; \
      }

#define __WIDGET_COLOR_PROPERTY_CASE(pPropId, pWidgetType) \
      case enColorProperty::pPropId: \
      { \
         pWidgetType* targetWidget = WidgetFinder::FindAncestorWidget<pWidgetType>(baseWidget); \
         if (targetWidget != NULL) \
         { \
            colorPropertyAccessor = FEATSTD_NEW(ColorPropertyAccessorBase<pWidgetType>)(targetWidget, enColorProperty::pPropId); \
         } \
         break; \
     }

/*****************************************************************************/
ColorPropertyAccessor* ColorPropertyHelper::Create(Candera::Widget2D& widget, Candera::Node2D& node, int propertyId)
{
   BaseWidget2D* baseWidget = Candera::Dynamic_Cast<BaseWidget2D*>(&widget);
   if (baseWidget == NULL)
   {
      return NULL;
   }

   ColorPropertyAccessor* colorPropertyAccessor = NULL;
   switch (propertyId)
   {
         __EFFECT_COLOR_PROPERTY_CASE(Effect_Color, None)
         __EFFECT_COLOR_PROPERTY_CASE(Effect_DropShadowColor, DropShadow)
         __EFFECT_COLOR_PROPERTY_CASE(Effect_OutlineColor, Outline)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_RichTextColor, RichTextWidget2D)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_RichTextHighlightColor, RichTextHighlightWidget2D)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_RichTextHighlightBgColor, RichTextHighlightWidget2D)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_TextAreaColor, TextAreaWidget2D)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_TextAreaHighlightColor, TextAreaWidget2D)
         __WIDGET_COLOR_PROPERTY_CASE(Widget_TextColor, TextWidget2D)

      default:
         break;
   }
   return colorPropertyAccessor;
}


}
}


}
