/* ***************************************************************************************
* FILE:          WindowRect.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WindowRect is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonWindowRect_h__
#define BlurWidgetCommonWindowRect_h__


namespace hmibase {
namespace widget {
namespace blur {

class WindowRect
{
   public:
      WindowRect();
      virtual ~WindowRect() {};

      void SetRectNormalized(const Candera::Rectangle& normalizedRect, Candera::Float maxWidth, Candera::Float maxHeight);

      Candera::Rectangle GetRectNormalized() const;

      void SetRectInPixel(const Candera::Rectangle& pixelRect, Candera::Float maxWidth, Candera::Float maxHeight);

      Candera::Rectangle GetRectInPixel() const;

      Candera::Float GetMaxPixelWidth() const;

      Candera::Float GetMaxPixelHeight() const;

   private:
      Candera::Rectangle  m_rect;
      Candera::Vector2    m_maxPixelSize;
};


}
}


}
#endif
