/* ***************************************************************************************
* FILE:          WindowRect.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WindowRect is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "WindowRect.h"

namespace hmibase {
namespace widget {
namespace blur {

WindowRect::WindowRect()
   : m_rect()
   , m_maxPixelSize()
{
}


void WindowRect::SetRectNormalized(const Candera::Rectangle& normalizedRect, Candera::Float maxWidth, Candera::Float maxHeight)
{
   m_maxPixelSize.SetX(maxWidth);
   m_maxPixelSize.SetY(maxHeight);

   m_rect.SetLeft(normalizedRect.GetLeft() * maxWidth);
   m_rect.SetTop(normalizedRect.GetTop() * maxHeight);

   if (normalizedRect.GetWidth() < 0.0F)
   {
      m_rect.SetWidth(maxWidth);
   }
   else
   {
      m_rect.SetWidth(normalizedRect.GetWidth() * maxWidth);
   }

   if (normalizedRect.GetHeight() < 0.0F)
   {
      m_rect.SetHeight(maxHeight);
   }
   else
   {
      m_rect.SetHeight(normalizedRect.GetHeight() * maxHeight);
   }
}


Candera::Rectangle WindowRect::GetRectNormalized() const
{
   Candera::Rectangle result;
   result.SetLeft(m_rect.GetLeft() / m_maxPixelSize.GetX());
   result.SetTop(m_rect.GetTop() / m_maxPixelSize.GetY());

   result.SetWidth(m_rect.GetWidth() / m_maxPixelSize.GetX());
   result.SetHeight(m_rect.GetHeight() / m_maxPixelSize.GetY());
   return result;
}


void WindowRect::SetRectInPixel(const Candera::Rectangle& pixelRect, Candera::Float maxWidth, Candera::Float maxHeight)
{
   m_maxPixelSize.SetX(maxWidth);
   m_maxPixelSize.SetY(maxHeight);
   m_rect.SetLeft(pixelRect.GetLeft());
   m_rect.SetTop(pixelRect.GetTop());

   if (pixelRect.GetWidth() < 0.0F)
   {
      m_rect.SetWidth(maxWidth);
   }
   else
   {
      m_rect.SetWidth(pixelRect.GetWidth());
   }

   if (pixelRect.GetHeight() < 0.0F)
   {
      m_rect.SetHeight(maxHeight);
   }
   else
   {
      m_rect.SetHeight(pixelRect.GetHeight());
   }
}


Candera::Rectangle WindowRect::GetRectInPixel() const
{
   return m_rect;
}


Candera::Float WindowRect::GetMaxPixelWidth() const
{
   return m_maxPixelSize.GetX();
}


Candera::Float WindowRect::GetMaxPixelHeight() const
{
   return m_maxPixelSize.GetY();
}


}
}


}
