/* ***************************************************************************************
* FILE:          BlurViewSceneFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurViewSceneFactory is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurViewSceneFactory_h__
#define BlurWidgetCommonSpace_BlurViewSceneFactory_h__

#ifdef COURIER_ENHANCED_ENABLED
#include <Courier/Visualization/ViewFactory.h>

namespace hmibase {
namespace widget {
namespace blur {

class BlurViewSceneFactory : public Courier::ViewFactory
{
      typedef Courier::ViewFactory Base;
   public:
      BlurViewSceneFactory() {};
      virtual ~BlurViewSceneFactory() {};
      virtual Courier::ViewScene* CreateViewScene(bool is2D);

      static Courier::ViewScene* CreateBlurViewScene(bool is2D, bool isManagedByViewHandler);
};


}
}


}
#endif  // #ifdef COURIER_ENHANCED_ENABLED
#endif  // BlurWidgetCommonSpace_BlurViewSceneFactory_h__
