/* ***************************************************************************************
* FILE:          BlurViewSceneFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurViewSceneFactory is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "BlurViewSceneFactory.h"
#include "Courier/Platform/Memory.h"

#ifdef COURIER_ENHANCED_ENABLED
#include "Widgets/3D/Blur/BlurViewScene3D.h"
#include "Widgets/2D/Blur/BlurViewScene2D.h"

namespace hmibase {
namespace widget {
namespace blur {

Courier::ViewScene* BlurViewSceneFactory::CreateViewScene(bool is2D)
{
   return CreateBlurViewScene(is2D, true);
}


Courier::ViewScene* BlurViewSceneFactory::CreateBlurViewScene(bool is2D, bool isManagedByViewHandler)
{
   if (is2D)
   {
      return COURIER_NEW(hmibase::widget::blur::BlurViewScene2D)(isManagedByViewHandler);
   }
   else
   {
      return COURIER_NEW(hmibase::widget::blur::BlurViewScene3D)(isManagedByViewHandler);
   }
}


}
}


}

#endif  //#ifdef COURIER_ENHANCED_ENABLED
