/* ***************************************************************************************
* FILE:          BlurUtilsCommon.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurUtilsCommon is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurUtilsCommon_h__
#define BlurWidgetCommonSpace_BlurUtilsCommon_h__

#include "BlurTypes.h"

namespace hmibase {
namespace widget {
namespace blur {

Candera::Node* GetFirstChildNodeOfType(Candera::Node* inParentNode, const Candera::TypeId inSearchType);

Candera::String GetBlurSceneName(Candera::String sceneName, Candera::Int passIndex);

class IBlurShader;
void CreateShaderType(IBlurShader** passOneShader, IBlurShader** passTwoShader, enShaderVariant::Enum shaderVariant, bool multipass);

template<typename T> bool IsSceneComposerCamera(T* inNode)
{
   if (inNode == NULL)
   {
      return false;
   }

   if ((inNode->GetDynamicTypeId() == Candera::Camera::GetTypeId()) ||
         (inNode->GetDynamicTypeId() == Candera::Camera2D::GetTypeId()))
   {
      std::string nameString = inNode->GetName();

      /* Scene Composer utilizes certain names for the cameras.
      If a camera with a special name is present, we assume running in
      Scene Composer.*/
      if ((0 == nameString.compare("Left!")) ||
            (0 == nameString.compare("Right!")) ||
            (0 == nameString.compare("Top!")) ||
            (0 == nameString.compare("Bottom!")) ||
            (0 == nameString.compare("Front!")) ||
            (0 == nameString.compare("Rear!")) ||
            (0 == nameString.compare("Editor!")))
      {
         return true;
      }
   }

   return false;
}


}
}


}

#endif // BlurWidgetCommonSpace_BlurUtilsCommon_h__
