/* ***************************************************************************************
* FILE:          BlurUtilsCommon.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurUtilsCommon is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "BlurUtilsCommon.h"
#include "Widgets/utils/Blur/IBlurShader.h"
#include "Widgets/utils/Blur/BlurShaderStatic.h"
#include "Widgets/utils/Blur/BlurShaderDynamic.h"
#include "Widgets/utils/Blur/BlurShaderCustom.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BLUR
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/BlurUtilsCommon.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace blur {


Candera::Node* GetFirstChildNodeOfType(Candera::Node* inParentNode, const Candera::TypeId inSearchType)
{
   if (NULL == inParentNode)
   {
      ETG_TRACE_ERR(("Parent node parameter equals NULL!"));
      return NULL;
   }
   Candera::Node* child = inParentNode->GetFirstChild();

   while (NULL != child)
   {
      if (child->GetDynamicTypeId() == inSearchType)
      {
         return child;
      }
      child = child->GetNextSibling();
   }
   return NULL;
}


Candera::String GetBlurSceneName(Candera::String sceneName, Candera::Int passIndex)
{
   if ((passIndex > 2) || (passIndex < 0))
   {
      return Candera::String("");
   }
   else
   {
      std::string passIndexString;

      if (passIndex == 1)
      {
         passIndexString = "1";
      }
      else if (passIndex == 2)
      {
         passIndexString = "2";
      }
      else
      {
         passIndexString = "";
      }
      std::string name(sceneName.GetCString());
      name += "#BlurPass";
      name += passIndexString;
      name += "!";
      return Candera::String(name.c_str());
   }
}


void CreateShaderType(IBlurShader** passOneShader, IBlurShader** passTwoShader, enShaderVariant::Enum shaderVariant, bool multipass)
{
   if (NULL != *passOneShader)
   {
      delete *passOneShader;
   }

   if (NULL != *passTwoShader)
   {
      delete *passTwoShader;
   }

   switch (shaderVariant)
   {
      case enShaderVariant::StaticShader:
         *passOneShader = reinterpret_cast<IBlurShader*>(new BlurShaderStatic(true, !multipass));

         if (multipass)
         {
            *passTwoShader = reinterpret_cast<IBlurShader*>(new BlurShaderStatic(false, true));
         }
         break;

      case enShaderVariant::CustomShader:
         *passOneShader = reinterpret_cast<IBlurShader*>(new BlurShaderCustom());
         *passTwoShader = reinterpret_cast<IBlurShader*>(new BlurShaderCustom());
         break;

      case enShaderVariant::DynamicShader:
      default:
         *passOneShader = reinterpret_cast<IBlurShader*>(new BlurShaderDynamic(true, !multipass));

         if (multipass)
         {
            *passTwoShader = reinterpret_cast<IBlurShader*>(new BlurShaderDynamic(false, true));
         }
         break;
   }
}


}
}


}
