/* ***************************************************************************************
* FILE:          BlurTypes.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurTypes.h is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _hmibase_BlurTypes_h_
#define _hmibase_BlurTypes_h_

//not possible to have nested namespaces with these macros
#define ENUM_DATA_TYPE_NAMESPACE hmi_base_widget_blur_enum_internal
#define ENUM_DATA_TYPE \
   ENUM_DATA_TYPE_BEGIN(enShaderVariant) \
   ENUM_DATA_TYPE_ITEM(StaticShader) \
   ENUM_DATA_TYPE_ITEM(DynamicShader) \
   ENUM_DATA_TYPE_ITEM(CustomShader) \
   ENUM_DATA_TYPE_END(enShaderVariant)

#include <Candera/System/MetaInfo/EnumDataType.h>

//not possible to have nested namespaces with these macros
#define ENUM_DATA_TYPE_NAMESPACE hmi_base_widget_blur_enum_internal
#define ENUM_DATA_TYPE \
   ENUM_DATA_TYPE_BEGIN(enBlurMaskVariant) \
   ENUM_DATA_TYPE_ITEM(RenderTargetBlurMask) \
   ENUM_DATA_TYPE_ITEM(BitmapBlurMask) \
   ENUM_DATA_TYPE_ITEM(NoBlurMask) \
   ENUM_DATA_TYPE_END(enBlurMaskVariant)

#include <Candera/System/MetaInfo/EnumDataType.h>

namespace hmibase {
namespace widget {
namespace blur {

//import the enum namespaces
using namespace hmi_base_widget_blur_enum_internal;
}


}
}


//aliases for the old namespaces
namespace  BlurWidgetCommonSpace = hmibase::widget::blur;
namespace  BlurWidget2DSpace = hmibase::widget::blur;
namespace  BlurWidget3DSpace = hmibase::widget::blur;

#endif  // _hmibase_BlurTypes_h_
