/* ***************************************************************************************
* FILE:          BlurShaderStatic.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusGroupWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurShaderStatic_h__
#define BlurWidgetCommonSpace_BlurShaderStatic_h__

#include "BlurShaderBase.h"

namespace hmibase {
namespace widget {
namespace blur {

typedef std::vector<Candera::Double> KernelRow;
typedef std::vector<KernelRow> KernelType;
typedef std::vector<Candera::Vector2> TexCoordRow;
typedef std::vector<TexCoordRow> TexCoords2D;

class BlurShaderStatic : protected BlurShaderBase
{
   public:
      BlurShaderStatic(bool initHorizontal, bool initVertical);
      ~BlurShaderStatic() {};

      virtual SharedPointerShaderType GetShader();

      virtual SharedPointerParamSetterType GetShaderParams();

      virtual bool HasValidShader();

      virtual bool HasValidParams();

      SharedPointerShaderType GenerateShader1D(bool inHorizontal, Candera::Int inTextureDimension, Candera::Double inSigma, Candera::Int inBlurRadius);

      SharedPointerShaderType GenerateShader2D(Candera::Int inTextureDimensionX, Candera::Int inTextureDimensionY, Candera::Double inSigma, Candera::Int inKernelRadius);

   protected:
      virtual void UpdateGuidString();

   private:
      std::string GenerateVertexShader1D() const;

      std::string GenerateVertexShader2D() const;

      std::string GenerateFragmentShader1D(bool inHorizontal, Candera::Int inTextureDimension, Candera::Double inSigma, Candera::Int inKernelRadius) const;

      std::string GenerateFragmentShader2D(Candera::Int inTextureDimensionX, Candera::Int inTextureDimensionY, Candera::Double inSigma, Candera::Int inKernelRadius) const;

      Candera::Double Gaussian(Candera::Double x, Candera::Double mu, Candera::Double sigma) const;

      KernelType Produce2dGaussianKernel(Candera::Double sigma, Candera::Int kernelRadius) const;

      KernelRow Produce1dGaussianKernel(Candera::Double sigma, Candera::Int kernelRadius) const;

      TexCoordRow Produce1dTexCoords(bool inHorizontal, Candera::Int inTextureDimension, Candera::Int kernelRadius) const;

      TexCoords2D Produce2dTexCoords(Candera::Int inTextureDimensionS, Candera::Int inTextureDimensionT, Candera::Int kernelRadius) const;

      std::string m_vertShaderSource;
      std::string m_fragShaderSource;

      SharedPointerShaderType m_shader;
      SharedPointerParamSetterType m_shaderParams;

      bool m_horizontal;
      bool m_vertical;
};


}
}


}
#endif
