/* ***************************************************************************************
* FILE:          BlurShaderDynamic.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurShaderDynamic is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurShaderDynamic_h__
#define BlurWidgetCommonSpace_BlurShaderDynamic_h__

#include "BlurShaderBase.h"

namespace hmibase {
namespace widget {
namespace blur {
class BlurShaderDynamic : protected BlurShaderBase
{
   public:
      BlurShaderDynamic(bool initHorizontal, bool initVertical);
      ~BlurShaderDynamic() {};

      virtual SharedPointerShaderType GetShader();

      virtual SharedPointerParamSetterType GetShaderParams();

      virtual bool HasValidShader();

      virtual bool HasValidParams();

      SharedPointerShaderType GenerateShader1D();

      SharedPointerShaderType GenerateShader2D();

   protected:
      virtual void UpdateGuidString();

   private:
      std::string GenerateVertexShader() const;

      std::string GenerateFragmentShader() const;

      std::string m_uniformBlurDirectionDelta;
      std::string m_uniformIncrementalGauss;

      Candera::Float m_incrementalGaussian[3];
      Candera::Float m_blurDirectionDelta[2];

      std::string m_vertShaderSource;
      std::string m_fragShaderSource;

      SharedPointerShaderType m_shader;
      SharedPointerParamSetterType m_shaderParams;

      bool m_horizontal;
      bool m_vertical;
};


}
}


}  // namespace
#endif  // BlurWidgetCommonSpace_BlurShaderDynamic_h__
